#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 mod
version:              0.2.1.0
visibility:           public
id:                   mod-0.2.1.0-9NK3FTp283tBl3rvapewPG
key:                  mod-0.2.1.0-9NK3FTp283tBl3rvapewPG
license:              MIT
copyright:            2017-2022 Andrew Lelechenko
maintainer:           Andrew Lelechenko <andrew.lelechenko@gmail.com>
author:               Andrew Lelechenko <andrew.lelechenko@gmail.com>
homepage:             https://github.com/Bodigrim/mod
synopsis:             Fast type-safe modular arithmetic
description:
    <https://en.wikipedia.org/wiki/Modular_arithmetic Modular arithmetic>,
    promoting moduli to the type level, with an emphasis on performance.
    Originally part of the <https://hackage.haskell.org/package/arithmoi arithmoi> package.

category:             Math, Number Theory
abi:                  5958b44c18e1fa700e2ee426397e614a
exposed:              True
exposed-modules:      Data.Mod Data.Mod.Word
hidden-modules:       Data.Mod.Compat
import-dirs:          /usr/lib/ghc-9.4.8/site-local/mod-0.2.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/mod-0.2.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/mod-0.2.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-mod
hs-libraries:         HSmod-0.2.1.0-9NK3FTp283tBl3rvapewPG
depends:
    base-4.17.2.1 deepseq-1.4.8.0 ghc-bignum-1.3
    primitive-0.9.1.0-6nUciex1vJZHfhyE758nym
    semirings-0.7-IrfFVUJZuh1D0rwcWcdWfW
    vector-0.13.2.0-B3Rnif6nhJNLHPAZlzHp2g

haddock-interfaces:   /usr/share/doc/haskell-mod/html/mod.haddock
haddock-html:         /usr/share/doc/haskell-mod/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

