#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 mod
version:              0.2.0.1
visibility:           public
id:                   mod-0.2.0.1-Jy6zPpSKwtLCNVlHVG3DQZ
key:                  mod-0.2.0.1-Jy6zPpSKwtLCNVlHVG3DQZ
license:              MIT
copyright:            2017-2022 Andrew Lelechenko
maintainer:           Andrew Lelechenko <andrew.lelechenko@gmail.com>
author:               Andrew Lelechenko <andrew.lelechenko@gmail.com>
homepage:             https://github.com/Bodigrim/mod
synopsis:             Fast type-safe modular arithmetic
description:
    <https://en.wikipedia.org/wiki/Modular_arithmetic Modular arithmetic>,
    promoting moduli to the type level, with an emphasis on performance.
    Originally part of the <https://hackage.haskell.org/package/arithmoi arithmoi> package.

category:             Math, Number Theory
abi:                  a0fea6ffe5eff7a245fc3707c6399122
exposed:              True
exposed-modules:      Data.Mod Data.Mod.Word
hidden-modules:       Data.Mod.Compat
import-dirs:          /usr/lib/ghc-9.4.8/site-local/mod-0.2.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/mod-0.2.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/mod-0.2.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-mod
hs-libraries:         HSmod-0.2.0.1-Jy6zPpSKwtLCNVlHVG3DQZ
depends:
    base-4.17.2.1 deepseq-1.4.8.0 ghc-bignum-1.3
    primitive-0.9.1.0-8nzcMUtKW4yAfvV7oeRfvP
    semirings-0.7-K49PobIGHxWKAS8xNFDOh
    vector-0.13.2.0-BxFNQQxQb2S1T9ycXEZ0Cs

haddock-interfaces:   /usr/share/doc/haskell-mod/html/mod.haddock
haddock-html:         /usr/share/doc/haskell-mod/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

