#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 mod
version:              0.2.0.1
visibility:           public
id:                   mod-0.2.0.1-E2Vhnu4AjOXCtsGGBilISf
key:                  mod-0.2.0.1-E2Vhnu4AjOXCtsGGBilISf
license:              MIT
copyright:            2017-2022 Andrew Lelechenko
maintainer:           Andrew Lelechenko <andrew.lelechenko@gmail.com>
author:               Andrew Lelechenko <andrew.lelechenko@gmail.com>
homepage:             https://github.com/Bodigrim/mod
synopsis:             Fast type-safe modular arithmetic
description:
    <https://en.wikipedia.org/wiki/Modular_arithmetic Modular arithmetic>,
    promoting moduli to the type level, with an emphasis on performance.
    Originally part of the <https://hackage.haskell.org/package/arithmoi arithmoi> package.

category:             Math, Number Theory
abi:                  4cae67a77ecf351b87b5f99e5c98069e
exposed:              True
exposed-modules:      Data.Mod Data.Mod.Word
hidden-modules:       Data.Mod.Compat
import-dirs:          /usr/lib/ghc-9.4.8/site-local/mod-0.2.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/mod-0.2.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/mod-0.2.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-mod
hs-libraries:         HSmod-0.2.0.1-E2Vhnu4AjOXCtsGGBilISf
depends:
    base-4.17.2.1 deepseq-1.4.8.0 ghc-bignum-1.3
    primitive-0.9.1.0-IHF3DoB9Qq2KNGfApZUSXg
    semirings-0.7-6KjAyMn4GgLI5L7wAD1g8m
    vector-0.13.2.0-CQ8QMV1t4PN5YFZtNXivGS

haddock-interfaces:   /usr/share/doc/haskell-mod/html/mod.haddock
haddock-html:         /usr/share/doc/haskell-mod/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

