#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 mod
version:              0.2.0.1
visibility:           public
id:                   mod-0.2.0.1-GwuCFQOG5415ltHwA9IaKs
key:                  mod-0.2.0.1-GwuCFQOG5415ltHwA9IaKs
license:              MIT
copyright:            2017-2022 Andrew Lelechenko
maintainer:           Andrew Lelechenko <andrew.lelechenko@gmail.com>
author:               Andrew Lelechenko <andrew.lelechenko@gmail.com>
homepage:             https://github.com/Bodigrim/mod
synopsis:             Fast type-safe modular arithmetic
description:
    <https://en.wikipedia.org/wiki/Modular_arithmetic Modular arithmetic>,
    promoting moduli to the type level, with an emphasis on performance.
    Originally part of the <https://hackage.haskell.org/package/arithmoi arithmoi> package.

category:             Math, Number Theory
abi:                  4993e6ad36c7b7afb8b1a1d22558b8ab
exposed:              True
exposed-modules:      Data.Mod Data.Mod.Word
hidden-modules:       Data.Mod.Compat
import-dirs:          /usr/lib/ghc-9.4.8/site-local/mod-0.2.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/mod-0.2.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/mod-0.2.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-mod
hs-libraries:         HSmod-0.2.0.1-GwuCFQOG5415ltHwA9IaKs
depends:
    base-4.17.2.1 deepseq-1.4.8.0 ghc-bignum-1.3
    primitive-0.9.1.0-8D3oUlMRcY7326zIYb2IW2
    semirings-0.7-KGWVVr19m8ofGFq9usaJH
    vector-0.13.2.0-GDtmlcfK9QZ7E5AlTQVnIi

haddock-interfaces:   /usr/share/doc/haskell-mod/html/mod.haddock
haddock-html:         /usr/share/doc/haskell-mod/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

