#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 math-functions
version:              0.3.4.4
visibility:           public
id:                   math-functions-0.3.4.4-2UquRDn5zIN3iS2uv4D92M
key:                  math-functions-0.3.4.4-2UquRDn5zIN3iS2uv4D92M
license:              BSD-2-Clause
maintainer:           Alexey Khudyakov <alexey.skladnoy@gmail.com>
author:
    Bryan O'\''Sullivan <bos@serpentine.com>,
    Alexey Khudyakov <alexey.skladnoy@gmail.com>

homepage:             https://github.com/haskell/math-functions
synopsis:             Collection of tools for numeric computations
description:
    This library contain collection of various utilities for numerical
    computing. So far there'\''re special mathematical functions,
    compensated summation algorithm, summation of series, root finding
    for real functions, polynomial summation and Chebyshev
    polynomials.

category:             Math, Numeric
abi:                  11cace0ba240103a7608e60520dfb5a1
exposed:              True
exposed-modules:
    Numeric.MathFunctions.Comparison Numeric.MathFunctions.Constants
    Numeric.Polynomial Numeric.Polynomial.Chebyshev Numeric.RootFinding
    Numeric.Series Numeric.SpecFunctions Numeric.SpecFunctions.Extra
    Numeric.SpecFunctions.Internal Numeric.Sum

hidden-modules:       Numeric.SpecFunctions.Compat
import-dirs:          /usr/lib/ghc-9.4.8/site-local/math-functions-0.3.4.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/math-functions-0.3.4.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/math-functions-0.3.4.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-math-functions
hs-libraries:         HSmath-functions-0.3.4.4-2UquRDn5zIN3iS2uv4D92M
depends:
    base-4.17.2.1 data-default-class-0.1.2.0-J3yYo85AtrC9KKZSpt62Yc
    deepseq-1.4.8.0 primitive-0.9.0.0-7BIYbmztPZn4k2gFg33YHr
    vector-0.13.2.0-4VMN5u23vSvFwbwe8QIFZ6

haddock-interfaces:
    /usr/share/doc/haskell-math-functions/html/math-functions.haddock

haddock-html:         /usr/share/doc/haskell-math-functions/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

