#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                   lua
version:                2.3.3
visibility:             public
id:                     lua-2.3.3-Hj4zKIrWigtKfFaIZ5HOpH
key:                    lua-2.3.3-Hj4zKIrWigtKfFaIZ5HOpH
license:                MIT
copyright:
    © 2007–2012 Gracjan Polak;
    © 2012–2016 Ömer Sinan Ağacan;
    © 2017-2024 Albert Krewinkel

maintainer:             Albert Krewinkel <tarleb@hslua.org>
author:                 Albert Krewinkel
homepage:               https://hslua.org/
synopsis:               Lua, an embeddable scripting language
description:
    This package provides bindings and types to bridge
    Haskell and <https://www.lua.org/ Lua>.

    The full Lua interpreter version 5.4.7 is included.
    Alternatively, a system-wide Lua installation can be
    linked instead.

category:               Foreign
abi:                    c44935945fe005aa815ad77539a7f033
exposed:                True
exposed-modules:
    Lua Lua.Auxiliary Lua.Call Lua.Constants Lua.Debug Lua.Ersatz
    Lua.Ersatz.Auxiliary Lua.Ersatz.Functions Lua.Lib Lua.Primary
    Lua.Types Lua.Userdata Lua.Warn

import-dirs:            /usr/lib/ghc-9.4.8/site-local/lua-2.3.3
library-dirs:           /usr/lib/ghc-9.4.8/site-local/lua-2.3.3
library-dirs-static:    /usr/lib/ghc-9.4.8/site-local/lua-2.3.3
dynamic-library-dirs:   /usr/lib
data-dir:               /usr/share/haskell-lua
hs-libraries:           HSlua-2.3.3-Hj4zKIrWigtKfFaIZ5HOpH
extra-libraries:        lua m
extra-libraries-static: lua m
includes:               lua.h luaconf.h lauxlib.h lualib.h
depends:                base-4.17.2.1
ld-options:             "-Wl,-E"
haddock-interfaces:     /usr/share/doc/haskell-lua/html/lua.haddock
haddock-html:           /usr/share/doc/haskell-lua/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

