#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              1.4.0.0
visibility:           public
id:                   lsp-1.4.0.0-A7n0BFJa1MX1XGX6WAEDZx
key:                  lsp-1.4.0.0-A7n0BFJa1MX1XGX6WAEDZx
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  0cf88887bb26a1c612d656679d84cf76
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Server,
    Language.LSP.Types from lsp-types-1.4.0.1-EodYKQ0JwMxHYAopbBoYye:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.4.0.1-EodYKQ0JwMxHYAopbBoYye:Language.LSP.Types.Capabilities,
    Language.LSP.Types.Lens from lsp-types-1.4.0.1-EodYKQ0JwMxHYAopbBoYye:Language.LSP.Types.Lens,
    Language.LSP.VFS from lsp-types-1.4.0.1-EodYKQ0JwMxHYAopbBoYye:Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Core Language.LSP.Server.Control
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp1.4
hs-libraries:         HSlsp-1.4.0.0-A7n0BFJa1MX1XGX6WAEDZx
depends:
    aeson-2.1.2.1-2ooOAwlErgbHj6Tyvuh2I5
    async-2.2.5-KIpQ4bNDIRO6XYT7v2y3ZE
    attoparsec-0.14.4-FDtC6GeLACtJHW3icA3qMM base-4.17.2.1
    bytestring-0.11.5.3 containers-0.6.7
    data-default-0.7.1.2-86VyjkfSCk63mGj7Z05i2D exceptions-0.10.5
    hashable-1.4.4.0-CTf4tWLvOCwE4B8hp3PoEK
    hslogger-1.3.1.2-Eg45tkdAwYYLR7iDN6wOZ8
    lens-5.3-AIJaKrXjlD5HhDEbilmzm0
    lsp-types-1.4.0.1-EodYKQ0JwMxHYAopbBoYye mtl-2.2.2
    network-uri-2.6.4.2-G7m9o4Qp8JT5z4xQAeqaNT
    random-1.2.1.3-K04qxPoOyGIAJkhpqYiZaH
    scientific-0.3.7.0-Kb5Gqy0LO2R6GqxRC9SGn9
    sorted-list-0.2.3.1-5dI0c0wGWqGLJypOL2Ea2d stm-2.5.1.0 text-2.0.2
    time-1.12.2 transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-5aRSzj1YCHv4h2N6lFa6Hx
    uuid-1.3.16-6hG9Ju9kOO04jaFQdWZPrF

haddock-interfaces:   /usr/share/doc/haskell-lsp1.4/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp1.4/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

