#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              1.4.0.0
visibility:           public
id:                   lsp-1.4.0.0-KEDNi7m8sY7C4X9E1JbEhy
key:                  lsp-1.4.0.0-KEDNi7m8sY7C4X9E1JbEhy
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  16a4716a45b35f2abc60627b3fd4292c
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Server,
    Language.LSP.Types from lsp-types-1.4.0.1-ATgDhgv4qfFH5C0QOMYDju:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.4.0.1-ATgDhgv4qfFH5C0QOMYDju:Language.LSP.Types.Capabilities,
    Language.LSP.Types.Lens from lsp-types-1.4.0.1-ATgDhgv4qfFH5C0QOMYDju:Language.LSP.Types.Lens,
    Language.LSP.VFS from lsp-types-1.4.0.1-ATgDhgv4qfFH5C0QOMYDju:Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Core Language.LSP.Server.Control
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp1.4
hs-libraries:         HSlsp-1.4.0.0-KEDNi7m8sY7C4X9E1JbEhy
depends:
    aeson-2.1.2.1-4cRYi3WcVwTKRqMhXUztfB
    async-2.2.5-GOsAYCd2Rtz3HW1WOZa8a9
    attoparsec-0.14.4-CvEJsUQt6CCDts1bkyqJXU base-4.17.2.1
    bytestring-0.11.5.3 containers-0.6.7
    data-default-0.7.1.2-86VyjkfSCk63mGj7Z05i2D exceptions-0.10.5
    hashable-1.4.4.0-4IkOt4KzeSSA3Xc4u5PLaT
    hslogger-1.3.1.2-HMJk3JrvLkgFTkI0qaqSnU
    lens-5.3-2T63PvFtwZXqnWv0im5sF
    lsp-types-1.4.0.1-ATgDhgv4qfFH5C0QOMYDju mtl-2.2.2
    network-uri-2.6.4.2-HPE7I962wSKDZCCiANqdpI
    random-1.2.1.3-FzrwJMuwwLv7643USShEPL
    scientific-0.3.7.0-K2KPplW6Nka7Ws1cS3R2Yx
    sorted-list-0.2.3.1-2GnDP4ox5wFD9YsDb9X4XY stm-2.5.1.0 text-2.0.2
    time-1.12.2 transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-A2tjqfQXDXnFd3Ae9FP0C3
    uuid-1.3.16-KozCGr8yCZOIY6gqBSwb5V

haddock-interfaces:   /usr/share/doc/haskell-lsp1.4/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp1.4/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

