#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp-test
version:              0.14.1.0
visibility:           public
id:                   lsp-test-0.14.1.0-ImbBrOtSiAY2b1vMCYigsj
key:                  lsp-test-0.14.1.0-ImbBrOtSiAY2b1vMCYigsj
license:              BSD-3-Clause
copyright:            2021 Luke Lau
maintainer:           luke_lau@icloud.com
author:               Luke Lau
homepage:
    https://github.com/haskell/lsp/blob/master/lsp-test/README.md

synopsis:             Functional test framework for LSP servers.
description:
    A test framework for writing tests against
    <https://microsoft.github.io/language-server-protocol/ Language Server Protocol servers>.
    @Language.LSP.Test@ launches your server as a subprocess and allows you to simulate a session
    down to the wire.
    To see examples of it in action, check out <https://github.com/haskell/haskell-ide-engine haskell-ide-engine>,
    <https://github.com/haskell/haskell-language-server haskell-language-server> and
    <https://github.com/digital-asset/ghcide ghcide>.

category:             Testing
abi:                  103e3c9b870c85477ce8b2e19ac826fe
exposed:              True
exposed-modules:
    Control.Applicative.Combinators from parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav:Control.Applicative.Combinators,
    Language.LSP.Test,
    Language.LSP.Types from lsp-types-1.6.0.1-EiVeTBiyXA56yjgxy5B66k:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.6.0.1-EiVeTBiyXA56yjgxy5B66k:Language.LSP.Types.Capabilities

hidden-modules:
    Language.LSP.Test.Compat Language.LSP.Test.Decoding
    Language.LSP.Test.Exceptions Language.LSP.Test.Files
    Language.LSP.Test.Parsing Language.LSP.Test.Server
    Language.LSP.Test.Session

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-test-0.14.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-test-0.14.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-test-0.14.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp-test
hs-libraries:         HSlsp-test-0.14.1.0-ImbBrOtSiAY2b1vMCYigsj
depends:
    Diff-0.4.1-4VjaazPwKkA8eC2BQCP8tm
    Glob-0.10.2-5xclHbvDGhqEu2LdSOR2mc
    aeson-2.1.2.1-4cRYi3WcVwTKRqMhXUztfB
    aeson-pretty-0.8.10-HNTMWj24mP2BSAsGYS1aNs
    ansi-terminal-1.0.2-4F37L3ko1KQ1hALBi4f5f0
    async-2.2.5-GOsAYCd2Rtz3HW1WOZa8a9 base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-FQxaimRMbCD72XNQ0BYLtJ
    conduit-1.3.6.1-KZNeLPeXvjD5EEhRbg4Ht8
    conduit-parse-0.2.1.1-KIzwG7xT0MILW3rNJBD7Wv containers-0.6.7
    data-default-0.7.1.2-86VyjkfSCk63mGj7Z05i2D directory-1.3.7.1
    exceptions-0.10.5 filepath-1.4.2.2 lens-5.3-2T63PvFtwZXqnWv0im5sF
    lsp-1.6.0.0-GX9aS0g7WYQKTWHFcgLnkB
    lsp-types-1.6.0.1-EiVeTBiyXA56yjgxy5B66k mtl-2.2.2
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav process-1.6.18.0
    some-1.0.6-3zkYDuZM8U6ADWfzDH6sC6 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unordered-containers-0.2.20-A2tjqfQXDXnFd3Ae9FP0C3

haddock-interfaces:   /usr/share/doc/haskell-lsp-test/html/lsp-test.haddock
haddock-html:         /usr/share/doc/haskell-lsp-test/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

