#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-AW1b6Rq1CNJFsxquT5PTmX
key:                  lsp-2.1.0.0-AW1b6Rq1CNJFsxquT5PTmX
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  0580e9604d0b52aee565dd57c282f1ac
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-6elClHnGATI1Z1UGJYpTkf:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-6elClHnGATI1Z1UGJYpTkf:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-6elClHnGATI1Z1UGJYpTkf:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-6elClHnGATI1Z1UGJYpTkf:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-AW1b6Rq1CNJFsxquT5PTmX
depends:
    aeson-2.1.2.1-3LOl3stht3x9JybSpHkoQT
    async-2.2.5-ELZ0ab9YXyNDIIErIFIBya
    attoparsec-0.14.4-IjP3u1baQ7d7AdktrTB8o9 base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-4mNB9WDBz5m6Hny36DSJXV
    containers-0.6.7 data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.7.0-bh6X3bZPF56LQTYQ27khw
    lens-5.3.3-26VlyqkFVMA2DXZQVmsUyD
    lsp-types-2.0.1.0-6elClHnGATI1Z1UGJYpTkf mtl-2.2.2
    prettyprinter-1.7.1-CmgwT0JRRi5IrbNzmhPK5a
    random-1.2.1.3-1QsPqNiQGepFTMKcu0aMcs
    row-types-1.0.1.2-4q6aARHc79V6g3EyMFIqI6
    sorted-list-0.2.3.1-2UQx9D8OKNvHKPQqnGn0PU stm-2.5.1.0
    temporary-1.3-7OlUYGsOxiE5dNsZFuxKnV text-2.0.2
    text-rope-0.3-27E8ULJs9xr7RIpRhKi0sE transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20.1-98Hg6PuNW0XDqLHXL1727Z
    uuid-1.3.16-4s9AN1K355r8CxDgaQNiHy

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

