#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-JRAvMRSrlV11n1YRb0fu3x
key:                  lsp-2.1.0.0-JRAvMRSrlV11n1YRb0fu3x
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  3fe6d0f7c57c39b7dec61b1b60ab4bda
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-8hg0mPllFF22mDu9d1NUSA:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-8hg0mPllFF22mDu9d1NUSA:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-8hg0mPllFF22mDu9d1NUSA:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-8hg0mPllFF22mDu9d1NUSA:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-JRAvMRSrlV11n1YRb0fu3x
depends:
    aeson-2.1.2.1-6h5MFvBT17H5yplsTy4ABm
    async-2.2.5-J9xl5BKgt0u6YsIOuQfrTS
    attoparsec-0.14.4-8oph4y3j0I1GXQUqU3wi8s base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-Lcc1SZOLXyqHHbh58cxUeJ
    containers-0.6.7 data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.7.0-GgneweRn8eTKcMM4X3n956
    lens-5.3.3-6cCVIdNEssO9Q1Aw8HDGhY
    lsp-types-2.0.1.0-8hg0mPllFF22mDu9d1NUSA mtl-2.2.2
    prettyprinter-1.7.1-HSfe9r3toGeG5iYKvTbBEv
    random-1.2.1.3-Kx84bR0MhuXELN1ev6GdTW
    row-types-1.0.1.2-FdMvYE7TraEI32MMNNmY44
    sorted-list-0.2.3.1-DOIeuvlDrbNKi71cz13QNr stm-2.5.1.0
    temporary-1.3-KbjBnRExPZiB3fvyB84Pcu text-2.0.2
    text-rope-0.3-AVNxYLyPV9vJ7y5KneRoBV transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-2N1fR83O3bC5qS2nrjaL2B
    uuid-1.3.16-BGbd2DS4gajB9FP9VbIx28

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

