#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-9XyVt29lBAMCkkqHJGjglp
key:                  lsp-2.1.0.0-9XyVt29lBAMCkkqHJGjglp
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  6446fdddd7ade03195cce6d78c009f2c
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-DQHAhGMdW4OH9eJBJinCgS:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-DQHAhGMdW4OH9eJBJinCgS:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-DQHAhGMdW4OH9eJBJinCgS:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-DQHAhGMdW4OH9eJBJinCgS:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-9XyVt29lBAMCkkqHJGjglp
depends:
    aeson-2.1.2.1-8gRdOgbBkF57DAEniCzHis
    async-2.2.5-JsOMVyOozRP6jACwcJZjUc
    attoparsec-0.14.4-BuoYNqKkZ0cK5gzfHXNsJW base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-68NHshMx2P09tBabRuAZGV
    containers-0.6.7 data-default-0.7.1.2-8zpNuXeugnsCXhsU9L7wsy
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-C1fFIG7AZLC7j0jzLm97Uw
    lens-5.3-6U8rnlrA3UzGhSFoVj5hOc
    lsp-types-2.0.1.0-DQHAhGMdW4OH9eJBJinCgS mtl-2.2.2
    prettyprinter-1.7.1-H0iQpJbBZ6k9IFy5REj5dh
    random-1.2.1.3-5GClgMcgHINEWJGyng3KHI
    row-types-1.0.1.2-KabGtSxjkYtEEos3B6aplf
    sorted-list-0.2.3.1-JHtuRsMp0T42Aq7On4rHUz stm-2.5.1.0
    temporary-1.3-DODaRJ5BM8m1pCh7H7okdb text-2.0.2
    text-rope-0.3-67Inpbs7SQML39U4jS9diO transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-obNV32ZSreHxgWRz6JrKP
    uuid-1.3.16-DPBdxgPSdwL3Pxt9uhiBrd

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

