#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-7Mw7nl9OqgXJOZWbl9wVQ3
key:                  lsp-2.1.0.0-7Mw7nl9OqgXJOZWbl9wVQ3
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  228c79e5e8495573e87f0541cb36ccb1
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-ExYjKqfW8zXGiw8krjix35:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-ExYjKqfW8zXGiw8krjix35:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-ExYjKqfW8zXGiw8krjix35:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-ExYjKqfW8zXGiw8krjix35:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-7Mw7nl9OqgXJOZWbl9wVQ3
depends:
    aeson-2.1.2.1-CoFGCad0PesDH4XC5ctCv4
    async-2.2.5-BbDohv985MkKG2Ydm62Fmc
    attoparsec-0.14.4-5QXKAIXHnspGYO0JElIsOr base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-9xKX6J32tfpDWnSbe4sBP4
    containers-0.6.7 data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.5.0-46ofdJt9DgFJv5hpm4ccL9
    lens-5.3.2-KbjCBznXoqo7Dk1sCj4PBt
    lsp-types-2.0.1.0-ExYjKqfW8zXGiw8krjix35 mtl-2.2.2
    prettyprinter-1.7.1-FOlixpN0mDDCGef0cfE7Yp
    random-1.2.1.3-3lKZsy50ahFJstdbQE9KC3
    row-types-1.0.1.2-7VRzowH8arZ3vl89agd3JU
    sorted-list-0.2.3.1-Dif4BzgEeyDISBaO8KXsP stm-2.5.1.0
    temporary-1.3-GqTQQZxhgaKHMmG7i0IazO text-2.0.2
    text-rope-0.3-IKCHGEl1RkxL4ejKnohOKv transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-9wNMaDmysQKAAHkxxaXhUB
    uuid-1.3.16-BbBIX8gTPF4DLSeQ6wlETQ

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

