#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-DnlBzEwRSs1GzYbMC2TL46
key:                  lsp-2.1.0.0-DnlBzEwRSs1GzYbMC2TL46
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  28f05ca852bdaacb432ef1da4311907f
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-5jJMlSPWJnWAjh7EPF4igK:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-5jJMlSPWJnWAjh7EPF4igK:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-5jJMlSPWJnWAjh7EPF4igK:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-5jJMlSPWJnWAjh7EPF4igK:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-DnlBzEwRSs1GzYbMC2TL46
depends:
    aeson-2.1.2.1-HPwo2VO3hzcFr4fiGB5Oro
    async-2.2.5-J9V4nOmLz7f63UCPGEHw4R
    attoparsec-0.14.4-4svHBw0u1Cc40MQ1AjsKLc base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-LpN8aQdBw01LbI15npD2uy
    containers-0.6.7 data-default-0.7.1.2-7c115eFpvxq7Z5z0er1qPt
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-HCL6HYi7vZb6weAXUagHtJ
    lens-5.3-pl18ecYYzn8sW5PtrryAE
    lsp-types-2.0.1.0-5jJMlSPWJnWAjh7EPF4igK mtl-2.2.2
    prettyprinter-1.7.1-CblNKNR1eKT9nxUoBiyJi9
    random-1.2.1.3-8vZ5nHC8xeMEF0rmgzNDZj
    row-types-1.0.1.2-DOn2CNArFntKBnx049S9DM
    sorted-list-0.2.3.1-8X4NaD1783RJFvF6zjOTh5 stm-2.5.1.0
    temporary-1.3-2XtnvHABNGf511WcFrV1ai text-2.0.2
    text-rope-0.3-ALF9SjbDbJQ6pIFGNI4Wxw transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-FFF0GulGLFtAHq6N1Lkm0s
    uuid-1.3.16-7eh7ZcnVP2h2XHfjB2kbbe

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

