#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-18Q2QtPoX9S3SH5LibVquJ
key:                  lsp-2.1.0.0-18Q2QtPoX9S3SH5LibVquJ
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  74f176c6cbb77196493a91cfe2a95f67
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-1eMLdOZCbkW9W9lcuT572q:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-1eMLdOZCbkW9W9lcuT572q:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-1eMLdOZCbkW9W9lcuT572q:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-1eMLdOZCbkW9W9lcuT572q:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-18Q2QtPoX9S3SH5LibVquJ
depends:
    aeson-2.1.2.1-F8ZePgr6g4xL6kF4wsQx0x
    async-2.2.5-BfPrxOOBs2Z6bEyvXKfM0q
    attoparsec-0.14.4-D7CECqktDgS2fYWStxbJq3 base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-HawXdeAW77I1gRubrAaYVq
    containers-0.6.7 data-default-0.7.1.2-2qohbnSvS9oK93FFGOJ5gM
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.5.0-FUZ3820cmTgAr6H2g2EQN7
    lens-5.3.1-FP95Rv35No71PYJue58Hxp
    lsp-types-2.0.1.0-1eMLdOZCbkW9W9lcuT572q mtl-2.2.2
    prettyprinter-1.7.1-AIJZZXuo91NCViNpmKNzcQ
    random-1.2.1.3-2Hw42CquWtj55joOjOmzRr
    row-types-1.0.1.2-5369p2bnKPg64LL4OeS28u
    sorted-list-0.2.3.1-88O85FYDDLrCMuv4rwWT5I stm-2.5.1.0
    temporary-1.3-IuvCcNxKbgM9H8NbQNEe0S text-2.0.2
    text-rope-0.3-3HhYxjhGqw9C3DTKJ31BQZ transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-I3GOf8berWn8tol6ImoSEe
    uuid-1.3.16-KPqM7fkGU7HIYn98FEGylF

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

