#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-8p5QghgyYvXASwShsdMKOc
key:                  lsp-2.1.0.0-8p5QghgyYvXASwShsdMKOc
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  b1669e688865c4cf019fe99bab3c3635
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-1lcU6Cj7QrDKqnHvcztpXd:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-1lcU6Cj7QrDKqnHvcztpXd:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-1lcU6Cj7QrDKqnHvcztpXd:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-1lcU6Cj7QrDKqnHvcztpXd:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-8p5QghgyYvXASwShsdMKOc
depends:
    aeson-2.1.2.1-56YME0rnoff9HEf3dDitk2
    async-2.2.5-HB5EOpH6TM6FYgOEK5nN87
    attoparsec-0.14.4-HrmGc7uWcHZBxPSUhHwhWb base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-9lsWCmcEXu4VGzLk0TfK5
    containers-0.6.7 data-default-0.7.1.2-2qohbnSvS9oK93FFGOJ5gM
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-7d9WFDaK31uHgEwdYM8cSb
    lens-5.3.1-9N2tK9zs7SGKEpVslmdE8u
    lsp-types-2.0.1.0-1lcU6Cj7QrDKqnHvcztpXd mtl-2.2.2
    prettyprinter-1.7.1-3l8vMA7BErkrlUUW8GNd2
    random-1.2.1.3-6fLOERitWZgLekqeklTRBb
    row-types-1.0.1.2-3rdc4Q1skxQ1nhh8NP1NJk
    sorted-list-0.2.3.1-KE9KmZqvLaTF6DPbd3yFYb stm-2.5.1.0
    temporary-1.3-7TrsRc1RsGE2CAll4JY0dE text-2.0.2
    text-rope-0.3-IO35yMJBg7o3WZjPkhSLH1 transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-90liAnN3BtD8VAzg2AGnlq
    uuid-1.3.16-E1KdiQGEVQ5Kfp84R8cLaR

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

