#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-HcMppEmwahbGJfRozlTO6I
key:                  lsp-2.1.0.0-HcMppEmwahbGJfRozlTO6I
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  8f96f615376f23896e405af007a2a25c
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-Jh7eSqOPRhD650t7q4OWJx:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-Jh7eSqOPRhD650t7q4OWJx:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-Jh7eSqOPRhD650t7q4OWJx:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-Jh7eSqOPRhD650t7q4OWJx:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-HcMppEmwahbGJfRozlTO6I
depends:
    aeson-2.1.2.1-GhEX0nU3rpe2rpNz8TrqEz
    async-2.2.5-5zadbbqeCp9HahDgxNyESl
    attoparsec-0.14.4-CZt0qAnGZHQHCYZEsndAye base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-KPheup4s9QwIOXLiKVIy5g
    containers-0.6.7 data-default-0.7.1.2-2qohbnSvS9oK93FFGOJ5gM
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-GXwYNb6ixbL0AOxKKxOK7
    lens-5.3.1-Jk0s21IZQ9F7Om7ixQU7VU
    lsp-types-2.0.1.0-Jh7eSqOPRhD650t7q4OWJx mtl-2.2.2
    prettyprinter-1.7.1-Hi17Zu3O6FiIO5eybHbcRR
    random-1.2.1.3-DyhQJBMZMiBKToaxsRw6jM
    row-types-1.0.1.2-4alUzAONsvULp2JZ7Zmg7O
    sorted-list-0.2.3.1-H0GtwTVVcDXFIh9rYg2iQL stm-2.5.1.0
    temporary-1.3-CsfJBYeBgjZ51GnRh5ob84 text-2.0.2
    text-rope-0.3-5Jo7ycdoa1X1LZjzrPhbQi transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-psp1ib8v1R5J9F619BTWH
    uuid-1.3.16-LSzdtMEZY34D3FkWOtBUzx

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

