#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-HibMFjN0zzBHKcYTMu9XX2
key:                  lsp-2.1.0.0-HibMFjN0zzBHKcYTMu9XX2
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  ff7f0cc4d3ed0bee4201eeeb3ab7fa98
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-K0zdjEn8QgaGK9svQeXb5v:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-K0zdjEn8QgaGK9svQeXb5v:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-K0zdjEn8QgaGK9svQeXb5v:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-K0zdjEn8QgaGK9svQeXb5v:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-HibMFjN0zzBHKcYTMu9XX2
depends:
    aeson-2.1.2.1-JflO2jKMgLf4qHLretO6v3
    async-2.2.5-13mgd2n56qe7oct6GfBbZY
    attoparsec-0.14.4-2LtDsLmLe3yKhxR8c5Iii0 base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-7FdfmOSKurK6V0UujJHqF1
    containers-0.6.7 data-default-0.7.1.2-95OdNmNpLKa9cNDp3ZlqO5
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-6tleuNdu8X41J3b2E1oOOY
    lens-5.3.1-1dHHf9jtSMJ2j1NVow6adv
    lsp-types-2.0.1.0-K0zdjEn8QgaGK9svQeXb5v mtl-2.2.2
    prettyprinter-1.7.1-Da1BCiI1NV6LfdDEPEDf77
    random-1.2.1.3-1kyQGGmKWocERAlRbbTx7C
    row-types-1.0.1.2-32nmiR3vt5t2jEKFPHlzVE
    sorted-list-0.2.3.1-AwRJASN99OrFhZ5CLraEBO stm-2.5.1.0
    temporary-1.3-2ypZUyYRP3aCh80JybXqFu text-2.0.2
    text-rope-0.3-GZklK8TYRfs5oeOcepSepA transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-Eo1ocpXri5ABLOF81VToPu
    uuid-1.3.16-Jyl91KWs3Qm4i2y6TI4SVc

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

