#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-gI4sjr8ace9num3GDSHxI
key:                  lsp-2.1.0.0-gI4sjr8ace9num3GDSHxI
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  2acf9adeddfd3f9d958ad42fac48a4f3
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-41n0CB01pJ7KmOXfiAXTb3:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-41n0CB01pJ7KmOXfiAXTb3:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-41n0CB01pJ7KmOXfiAXTb3:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-41n0CB01pJ7KmOXfiAXTb3:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-gI4sjr8ace9num3GDSHxI
depends:
    aeson-2.1.2.1-F9MXb1A8ug6GkYytoGh4jA
    async-2.2.5-IlWxKJCaUbFHok4DWrcmNB
    attoparsec-0.14.4-Ie40PJLLZWYz4b9BsvrTL base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-EUhrJ5THpPT6kmMqMqPsv7
    containers-0.6.7 data-default-0.7.1.2-7c115eFpvxq7Z5z0er1qPt
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-FG1b1gw3lrmKPDYe5KupbE
    lens-5.3-HdczP0no6IA6OsB2lfUnLL
    lsp-types-2.0.1.0-41n0CB01pJ7KmOXfiAXTb3 mtl-2.2.2
    prettyprinter-1.7.1-3W0ElPC5NNG6rVoiMzjO1q
    random-1.2.1.3-HKo4lgWEYIB4bNnBF1GZit
    row-types-1.0.1.2-GqmgKmGmnsi4eV263XLFDQ
    sorted-list-0.2.3.1-5D5Tai4el9ULTaF5NqF2dO stm-2.5.1.0
    temporary-1.3-r6dyYReZ4U5F588bXwn5f text-2.0.2
    text-rope-0.3-7b7rzGmzDO85FKxlus88gh transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-Kb1zmdIZFsX5Z4trT8w0xB
    uuid-1.3.16-GsoaNDz52Va652hUbE5wIy

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

