#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-2r7Z29fE5rZ2FQGC2gdzUu
key:                  lsp-2.1.0.0-2r7Z29fE5rZ2FQGC2gdzUu
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  81cdaded84b640b341258434c3e7c6ee
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-2dqpRVgGEdU1cWxJI6WMTu:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-2dqpRVgGEdU1cWxJI6WMTu:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-2dqpRVgGEdU1cWxJI6WMTu:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-2dqpRVgGEdU1cWxJI6WMTu:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-2r7Z29fE5rZ2FQGC2gdzUu
depends:
    aeson-2.1.2.1-wY4CXNP4Ti6TCaMY1tyMf
    async-2.2.5-HgJvyv8nLlGBOZUsxEMYyx
    attoparsec-0.14.4-GTfBnxih117FV8L70A8efO base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-KfeqM8iw34lBfNy2PBo9GJ
    containers-0.6.7 data-default-0.7.1.2-LONLsSvT4G81IL8ks6Ql72
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-ER9qsIVdqB66mmnPytAzi1
    lens-5.3.1-HP4sFfbh3y9B4laWgY1DEm
    lsp-types-2.0.1.0-2dqpRVgGEdU1cWxJI6WMTu mtl-2.2.2
    prettyprinter-1.7.1-AWOpW71pl8nIJPFNGLPbj
    random-1.2.1.3-7z4mPLTBPidE9rbVioKqnW
    row-types-1.0.1.2-1gJjEB1uK959UI383htLpX
    sorted-list-0.2.3.1-KN2eo0xkysD4j3iiXe06QR stm-2.5.1.0
    temporary-1.3-3NOXbZBNm6jw25HF8dLG0 text-2.0.2
    text-rope-0.3-BQw1Xq6k3AZEhWEKQQiIv8 transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-BdnqkwZm9bx6ocoMK9HG74
    uuid-1.3.16-L4oZK2xz30658Gk2kqaZh

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

