#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-BDHHPzj6fBlK30HTjE0Bnz
key:                  lsp-2.1.0.0-BDHHPzj6fBlK30HTjE0Bnz
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  ec93b18568707f10de1a471aa7a31513
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-IUome6Dk8hLgDvyZbVm4k:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-IUome6Dk8hLgDvyZbVm4k:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-IUome6Dk8hLgDvyZbVm4k:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-IUome6Dk8hLgDvyZbVm4k:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-BDHHPzj6fBlK30HTjE0Bnz
depends:
    aeson-2.1.2.1-2ooOAwlErgbHj6Tyvuh2I5
    async-2.2.5-KIpQ4bNDIRO6XYT7v2y3ZE
    attoparsec-0.14.4-FDtC6GeLACtJHW3icA3qMM base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-F1KKnrPMUYmH8Mt75uuJwg
    containers-0.6.7 data-default-0.7.1.2-86VyjkfSCk63mGj7Z05i2D
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-CTf4tWLvOCwE4B8hp3PoEK
    lens-5.3-AIJaKrXjlD5HhDEbilmzm0
    lsp-types-2.0.1.0-IUome6Dk8hLgDvyZbVm4k mtl-2.2.2
    prettyprinter-1.7.1-EqfzrdoXeXwBZWVdz9UKUZ
    random-1.2.1.3-K04qxPoOyGIAJkhpqYiZaH
    row-types-1.0.1.2-5QzEc8t5ZDBoBjQvXDkaG
    sorted-list-0.2.3.1-5dI0c0wGWqGLJypOL2Ea2d stm-2.5.1.0
    temporary-1.3-54wigIt31kD6f0c4NQmX2X text-2.0.2
    text-rope-0.3-HqMeOupWmzk46ZhsazPLkY transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-5aRSzj1YCHv4h2N6lFa6Hx
    uuid-1.3.16-6hG9Ju9kOO04jaFQdWZPrF

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

