#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-L0nY2m9p5xP4ItlDGFfaVG
key:                  lsp-2.1.0.0-L0nY2m9p5xP4ItlDGFfaVG
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  156a9d31c2325e9e6f6a23c51a659c34
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-CJWPaNCFZuwBck3D8lxYgu:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-CJWPaNCFZuwBck3D8lxYgu:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-CJWPaNCFZuwBck3D8lxYgu:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-CJWPaNCFZuwBck3D8lxYgu:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-L0nY2m9p5xP4ItlDGFfaVG
depends:
    aeson-2.1.2.1-JD8QPsoBF4NC1qVY6ch6us
    async-2.2.5-Tatd1blDDeFXcniqPZgAh
    attoparsec-0.14.4-LYMz7sGPlLCLdIXUlDCVP9 base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-IT9NmLYd53d17tlLVZ7kTl
    containers-0.6.7 data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-AFqmlTE0BBaCoTGEV5znl2
    lens-5.3.1-JV4NgTTRRUD4MjO8VGr2iB
    lsp-types-2.0.1.0-CJWPaNCFZuwBck3D8lxYgu mtl-2.2.2
    prettyprinter-1.7.1-5cxpZ3jZU7h3nFjq43pkKP
    random-1.2.1.3-7QJJoQOVHAI1PeONmcyhZ
    row-types-1.0.1.2-Gix2o5qTy1e21VUMzFcoF2
    sorted-list-0.2.3.1-61p9tbXx9odJbh5EKlHQnd stm-2.5.1.0
    temporary-1.3-5ykvKjhsciDABbzBam51Ha text-2.0.2
    text-rope-0.3-CEmEzUU9qZBJfx7ZiXYSDz transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-ASGEyX3xTBf3ZK5sYSGlF8
    uuid-1.3.16-6LbWjn0qtVGBCyQuJNCPsW

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

