#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-46KWoWDNbr41RhWuGlOEnr
key:                  lsp-2.1.0.0-46KWoWDNbr41RhWuGlOEnr
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  78bf39e21b72a2f6de8178aaa7220b64
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-5NHK0cFA7WBJufPmv1hc1Q:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-5NHK0cFA7WBJufPmv1hc1Q:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-5NHK0cFA7WBJufPmv1hc1Q:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-5NHK0cFA7WBJufPmv1hc1Q:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-46KWoWDNbr41RhWuGlOEnr
depends:
    aeson-2.1.2.1-4cRYi3WcVwTKRqMhXUztfB
    async-2.2.5-GOsAYCd2Rtz3HW1WOZa8a9
    attoparsec-0.14.4-CvEJsUQt6CCDts1bkyqJXU base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-FQxaimRMbCD72XNQ0BYLtJ
    containers-0.6.7 data-default-0.7.1.2-86VyjkfSCk63mGj7Z05i2D
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-4IkOt4KzeSSA3Xc4u5PLaT
    lens-5.3-2T63PvFtwZXqnWv0im5sF
    lsp-types-2.0.1.0-5NHK0cFA7WBJufPmv1hc1Q mtl-2.2.2
    prettyprinter-1.7.1-G4E3PI2BTIHFT7NfmJKOqD
    random-1.2.1.3-FzrwJMuwwLv7643USShEPL
    row-types-1.0.1.2-D9xzuZXWpK61B2LMFDGqzj
    sorted-list-0.2.3.1-2GnDP4ox5wFD9YsDb9X4XY stm-2.5.1.0
    temporary-1.3-9YGAaKVvZD6I8n4DFMUpuQ text-2.0.2
    text-rope-0.3-9WyesksBPkgH4ywcluimty transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-A2tjqfQXDXnFd3Ae9FP0C3
    uuid-1.3.16-KozCGr8yCZOIY6gqBSwb5V

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

