#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 libmpd
version:              0.10.0.1
visibility:           public
id:                   libmpd-0.10.0.1-DNI9sXcAijsKAInaqYAlao
key:                  libmpd-0.10.0.1-DNI9sXcAijsKAInaqYAlao
license:              MIT
copyright:
    Ben Sinclair 2005-2009, Joachim Fasting 2007-2015,
    Daniel Schoepe 2009, Andrzej Rybczak 2010,
    Simon Hengel 2011-2014, Niklas Haas 2012,
    Matvey Aksenov 2014, Wieland Hoffmann 2014,
    Tim Heap 2014, Tobias Brandt 2014

maintainer:           Joachim Fasting <joachifm@fastmail.fm>
author:               Ben Sinclair
stability:            beta
homepage:             http://github.com/vimus/libmpd-haskell#readme
synopsis:             An MPD client library.
description:          A client library for MPD, the Music Player Daemon.
category:             Network, Sound
abi:                  31a2aa325699b5d82092eb2e0091f8ce
exposed:              True
exposed-modules:
    Network.MPD Network.MPD.Applicative
    Network.MPD.Applicative.ClientToClient
    Network.MPD.Applicative.Connection
    Network.MPD.Applicative.CurrentPlaylist
    Network.MPD.Applicative.Database Network.MPD.Applicative.Mount
    Network.MPD.Applicative.Output
    Network.MPD.Applicative.PlaybackControl
    Network.MPD.Applicative.PlaybackOptions
    Network.MPD.Applicative.Reflection Network.MPD.Applicative.Status
    Network.MPD.Applicative.Stickers
    Network.MPD.Applicative.StoredPlaylists
    Network.MPD.Commands.Extensions Network.MPD.Core

hidden-modules:
    Network.MPD.Core.Class Network.MPD.Core.Error Network.MPD.Commands
    Network.MPD.Commands.Arg Network.MPD.Commands.Parse
    Network.MPD.Commands.Query Network.MPD.Commands.Types
    Network.MPD.Commands.ClientToClient Network.MPD.Commands.Status
    Network.MPD.Commands.PlaybackOptions
    Network.MPD.Commands.PlaybackControl
    Network.MPD.Commands.CurrentPlaylist
    Network.MPD.Commands.StoredPlaylists Network.MPD.Commands.Database
    Network.MPD.Commands.Stickers Network.MPD.Commands.Connection
    Network.MPD.Commands.Output Network.MPD.Commands.Reflection
    Network.MPD.Commands.Mount Network.MPD.Applicative.Util
    Network.MPD.Applicative.Internal Network.MPD.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/libmpd-0.10.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/libmpd-0.10.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/libmpd-0.10.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-libmpd
hs-libraries:         HSlibmpd-0.10.0.1-DNI9sXcAijsKAInaqYAlao
depends:
    attoparsec-0.14.4-99Ep8AgC5YbKR8GAd3oR9D base-4.17.2.1
    bytestring-0.11.5.3 containers-0.6.7
    data-default-class-0.1.2.2-2EcHBs5cfSFLku8331ZnRi filepath-1.4.2.2
    mtl-2.2.2 network-3.1.4.0-3FUQiZBqCiD6JAPkelGiT0
    safe-exceptions-0.1.7.4-83d8SMdOaWCJZPBryR3dxr text-2.0.2
    time-1.12.2 utf8-string-1.0.2-6nfZpgw1Ffy3MDnMPT0XX9

haddock-interfaces:   /usr/share/doc/haskell-libmpd/html/libmpd.haddock
haddock-html:         /usr/share/doc/haskell-libmpd/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

