#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 kvitable
version:              1.1.0.1
visibility:           public
id:                   kvitable-1.1.0.1-H3i4QY3eYez3Fdhpx7QG25
key:                  kvitable-1.1.0.1-H3i4QY3eYez3Fdhpx7QG25
license:              ISC
copyright:            Kevin Quick, 2021-2022
maintainer:           kquick@galois.com
author:               Kevin Quick
homepage:             https://github.com/kquick/kvitable
synopsis:             Key/Value Indexed Table container and formatting library
description:

    Allows creation of a table from a set of of Key+Value Indices.
    This differs from the standard '\''Map'\'' structure in that the '\''Map'\''
    simply indexes by value but the KVI table indexes by a
    heterogeneous list of keys along with their associated values.
    This effectively creates an N-dimensional table, where
    @N=Product(Count(Values[key]))@.  The table contents can be sparse.

    This library also provides the ability to format multi-dimensional
    data in a table presentation.  The table is automatically formatted
    and can be output in a number of different styles (ascii, html,
    etc.)

    Multi-dimensional data is more difficult to represent than simple
    two-dimensional data; this package provides the ability to select
    which dimensions should be represented as sub-rows and which
    dimensions should be represented as sub-columns.  See the README
    for examples

category:             Text
abi:                  a77eb51da7bdc71c8870409595f1a440
exposed:              True
exposed-modules:
    Data.KVITable Data.KVITable.Internal.Helpers Data.KVITable.Render
    Data.KVITable.Render.ASCII Data.KVITable.Render.HTML
    Data.KVITable.Render.Internal

import-dirs:          /usr/lib/ghc-9.4.8/site-local/kvitable-1.1.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/kvitable-1.1.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/kvitable-1.1.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-kvitable
hs-libraries:         HSkvitable-1.1.0.1-H3i4QY3eYez3Fdhpx7QG25
depends:
    base-4.17.2.1 containers-0.6.7
    lucid-2.11.20230408-9XStOCn9r58DdHooc9ig19
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    named-text-1.2.1.0-JUzHJHEaf8TGXrA7ltvRt4
    sayable-1.2.5.0-7SA3KWadR4z2YADPJ9RkVg text-2.0.2

haddock-interfaces:   /usr/share/doc/haskell-kvitable/html/kvitable.haddock
haddock-html:         /usr/share/doc/haskell-kvitable/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

