#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 jose
version:              0.10
visibility:           public
id:                   jose-0.10-D9BprMI1GHuDJABiy2ST0L
key:                  jose-0.10-D9BprMI1GHuDJABiy2ST0L
license:              Apache-2.0
copyright:            Copyright (C) 2013-2021  Fraser Tweedale
maintainer:           frase@frase.id.au
author:               Fraser Tweedale
homepage:             https://github.com/frasertweedale/hs-jose
synopsis:
    JSON Object Signing and Encryption (JOSE) and JSON Web Token (JWT) library

description:

    Implementation of JSON Object Signing and Encryption
    (JOSE) and JSON Web Token (JWT; RFC 7519).

    The JSON Web Signature (JWS; RFC 7515) implementation is complete.

    EdDSA signatures (RFC 8037) and secp256k1 (RFC 8812) are supported.

    JWK Thumbprint (RFC 7638) is supported.

    JSON Web Encryption (JWE; RFC 7516) is not yet implemented.

    The __ECDSA implementation is vulnerable to timing attacks__ and
    should only be used for verification.

category:             Cryptography
abi:                  d4fecb6f1a190d08bdb9b9e13cd4ae6c
exposed:              True
exposed-modules:
    Crypto.JOSE Crypto.JOSE.AESKW Crypto.JOSE.Compact Crypto.JOSE.Error
    Crypto.JOSE.Header Crypto.JOSE.JWA.JWE Crypto.JOSE.JWA.JWE.Alg
    Crypto.JOSE.JWA.JWK Crypto.JOSE.JWA.JWS Crypto.JOSE.JWE
    Crypto.JOSE.JWK Crypto.JOSE.JWK.Store Crypto.JOSE.JWS
    Crypto.JOSE.Types Crypto.JWT

hidden-modules:
    Crypto.JOSE.TH Crypto.JOSE.Types.Internal Crypto.JOSE.Types.URI

import-dirs:          /usr/lib/ghc-9.4.8/site-local/jose-0.10
library-dirs:         /usr/lib/ghc-9.4.8/site-local/jose-0.10
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/jose-0.10
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-jose
hs-libraries:         HSjose-0.10-D9BprMI1GHuDJABiy2ST0L
depends:
    aeson-2.1.2.1-HdmwuFbnNgF6PqutsUaf6Y base-4.17.2.1
    base64-bytestring-1.2.1.0-B2irD5s7HHEKJGrPbG6ke5
    bytestring-0.11.5.3 concise-0.1.0.1-DOKUensQXdIHWPBuAJpCi9
    containers-0.6.7 cryptonite-0.30-1MbB7YQFgNJFgcGqpqgSsE
    lens-5.3-L5hp9JbMaZ3ARz3g7EupwI
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-time-0.4.0.0-LPoHPY62S3DIdducY8Hb6X mtl-2.2.2
    network-uri-2.6.4.2-9UqT53JjEGDF2lVDrQUMu1
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    x509-1.7.7-CFcuNqxjxeyFn9gl4IMxlJ

haddock-interfaces:   /usr/share/doc/haskell-jose/html/jose.haddock
haddock-html:         /usr/share/doc/haskell-jose/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

