#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 io-streams
version:              1.5.2.2
visibility:           public
id:                   io-streams-1.5.2.2-AzJvOi0FZyq61LfLhYn0Od
key:                  io-streams-1.5.2.2-AzJvOi0FZyq61LfLhYn0Od
license:              BSD-3-Clause
maintainer:           Gregory Collins <greg@gregorycollins.net>
synopsis:             Simple, composable, and easy-to-use stream I/O
description:
    /Overview/

    The io-streams library contains simple and easy-to-use primitives for I/O
    using streams. Most users will want to import the top-level convenience
    module "System.IO.Streams", which re-exports most of the library:

    @
    import           System.IO.Streams (InputStream, OutputStream)
    import qualified System.IO.Streams as Streams
    @

    For first-time users, @io-streams@ comes with an included tutorial, which can
    be found in the "System.IO.Streams.Tutorial" module.

    /Features/

    The @io-streams@ user API has two basic types: @InputStream a@ and
    @OutputStream a@, and three fundamental I/O primitives:

    @
    \-\- read an item from an input stream
    Streams.read :: InputStream a -> IO (Maybe a)

    \-\- push an item back to an input stream
    Streams.unRead :: a -> InputStream a -> IO ()

    \-\- write to an output stream
    Streams.write :: Maybe a -> OutputStream a -> IO ()
    @

    Streams can be transformed by composition and hooked together with provided combinators:

    @
    ghci> Streams.fromList [1,2,3::Int] >>= Streams.map (*10) >>= Streams.toList
    [10,20,30]
    @

    Stream composition leaves the original stream accessible:

    @
    ghci> input \<- Streams.fromByteString \"long string\"
    ghci> wrapped \<- Streams.takeBytes 4 input
    ghci> Streams.read wrapped
    Just \"long\"
    ghci> Streams.read wrapped
    Nothing
    ghci> Streams.read input
    Just \" string\"
    @

    Simple types and operations in the IO monad mean straightforward and simple
    exception handling and resource cleanup using Haskell standard library
    facilities like '\''Control.Exception.bracket'\''.

    @io-streams@ comes with:

    * functions to use files, handles, concurrent channels, sockets, lists,
    vectors, and more as streams.

    * a variety of combinators for wrapping and transforming streams, including
    compression and decompression using zlib, controlling precisely how many
    bytes are read from or written to a stream, buffering output using
    bytestring builders, folds, maps, filters, zips, etc.

    * support for parsing from streams using @attoparsec@.

    * support for spawning processes and communicating with them using streams.

category:             Data, Network, IO-Streams
abi:                  3a2358b8217d696d1e02e997983822eb
exposed:              True
exposed-modules:
    System.IO.Streams System.IO.Streams.Attoparsec
    System.IO.Streams.Attoparsec.ByteString
    System.IO.Streams.Attoparsec.Text System.IO.Streams.Builder
    System.IO.Streams.ByteString System.IO.Streams.Combinators
    System.IO.Streams.Concurrent System.IO.Streams.Core
    System.IO.Streams.Debug System.IO.Streams.File
    System.IO.Streams.Handle System.IO.Streams.Internal
    System.IO.Streams.List System.IO.Streams.Network
    System.IO.Streams.Process System.IO.Streams.Text
    System.IO.Streams.Tutorial System.IO.Streams.Vector
    System.IO.Streams.Zlib

hidden-modules:
    System.IO.Streams.Internal.Attoparsec
    System.IO.Streams.Internal.Search
    System.IO.Streams.Internal.Network

import-dirs:          /usr/lib/ghc-9.4.8/site-local/io-streams-1.5.2.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/io-streams-1.5.2.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/io-streams-1.5.2.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-io-streams
hs-libraries:         HSio-streams-1.5.2.2-AzJvOi0FZyq61LfLhYn0Od
depends:
    attoparsec-0.14.4-AfQEBsI4KfUBbsB9NxUVAd base-4.17.2.1
    bytestring-0.11.5.3 network-3.1.4.0-1Bok7DDOmdQ7OlyZLPDJ7H
    primitive-0.9.1.0-IHF3DoB9Qq2KNGfApZUSXg process-1.6.18.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    vector-0.13.2.0-CQ8QMV1t4PN5YFZtNXivGS
    zlib-bindings-0.1.1.5-JyTHNoeSY6wIlQoP3jbmgs

haddock-interfaces:   /usr/share/doc/haskell-io-streams/html/io-streams.haddock
haddock-html:         /usr/share/doc/haskell-io-streams/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

