#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 indexed-traversable
version:              0.1.4
visibility:           public
id:                   indexed-traversable-0.1.4-2T176InstcMqAaY6WCojl
key:                  indexed-traversable-0.1.4-2T176InstcMqAaY6WCojl
license:              BSD-2-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Edward Kmett
synopsis:             FunctorWithIndex, FoldableWithIndex, TraversableWithIndex
description:
    This package provides three useful generalizations:

    @
    class Functor f => FunctorWithIndex i f | f -> i where
    \  imap :: (i -> a -> b) -> f a -> f b
    @

    @
    class Foldable f => FoldableWithIndex i f | f -> i where
    \  ifoldMap :: Monoid m => (i -> a -> m) -> f a -> m
    @

    @
    class (FunctorWithIndex i t, FoldableWithIndex i t, Traversable t) => TraversableWithIndex i t | t -> i where
    \  itraverse :: Applicative f => (i -> a -> f b) -> t a -> f (t b)
    @

    This package contains instances for types in GHC boot libraries.
    For some additional instances see [indexed-traversable-instances](https://hackage.haskell.org/package/indexed-traversable-instances).

    The [keys](https://hackage.haskell.org/package/keys) package provides similar functionality,
    but uses (associated) @TypeFamilies@ instead of @FunctionalDependencies@.

category:             Data
abi:                  b1c274f6a76a9ed51897868352140d1c
exposed:              True
exposed-modules:
    Data.Foldable.WithIndex Data.Foldable1.WithIndex
    Data.Functor.WithIndex Data.Traversable.WithIndex

hidden-modules:       CoerceCompat GhcList WithIndex
import-dirs:          /usr/lib/ghc-9.4.8/site-local/indexed-traversable-0.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/indexed-traversable-0.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/indexed-traversable-0.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-indexed-traversable
hs-libraries:         HSindexed-traversable-0.1.4-2T176InstcMqAaY6WCojl
depends:
    array-0.5.4.0 base-4.17.2.1 containers-0.6.7
    foldable1-classes-compat-0.1.1-b72stJcCAb49xOcrO8X8T
    transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-indexed-traversable/html/indexed-traversable.haddock

haddock-html:         /usr/share/doc/haskell-indexed-traversable/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

