#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 incremental-parser
version:              0.5.1
visibility:           public
id:                   incremental-parser-0.5.1-7TVjgmRYOWX62bHvy3EsTs
key:                  incremental-parser-0.5.1-7TVjgmRYOWX62bHvy3EsTs
license:              GPL-3.0-only
copyright:            (c) 2011-2023 Mario Blazevic
maintainer:           blamario@yahoo.com
author:               Mario Blazevic
homepage:             https://github.com/blamario/incremental-parser
synopsis:
    Generic parser library capable of providing partial results from partial input.

description:
    This package defines yet another parser combinator library. This one is implemented using the concept of Brzozowski
    derivatives, tweaked and optimized to work with any monoidal input type. Lists, ByteString, and Text are supported out
    of the box, as well as any other data type for which the monoid-subclasses package defines instances. If the parser
    result is also a monoid, its chunks can be extracted incrementally, before the complete input is parsed.

category:             Parsing
abi:                  57146f9faf9a9171a272f6dd2f1a75e9
exposed:              True
exposed-modules:
    Control.Applicative.Monoid Text.ParserCombinators.Incremental
    Text.ParserCombinators.Incremental.LeftBiasedLocal
    Text.ParserCombinators.Incremental.Symmetric

import-dirs:          /usr/lib/ghc-9.4.8/site-local/incremental-parser-0.5.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/incremental-parser-0.5.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/incremental-parser-0.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-incremental-parser
hs-libraries:         HSincremental-parser-0.5.1-7TVjgmRYOWX62bHvy3EsTs
depends:
    base-4.17.2.1 input-parsers-0.3.0.2-5Y2Z6xz0Nad8ZsPRX2DyVW
    logict-0.8.1.0-5AbWCTi8KMRKx3OUlo69wL
    monoid-subclasses-1.2.6-5vOhDjqdPhv1AexVxNLfMX
    parsers-0.12.12-GlcXgK72POlBWcSo2X9bth
    rank2classes-1.5.4-5T8SZulaH2bGPoVKjRqFQ7 transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-incremental-parser/html/incremental-parser.haddock

haddock-html:         /usr/share/doc/haskell-incremental-parser/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

