#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 http2
version:              4.2.2
visibility:           public
id:                   http2-4.2.2-9Su0rTsdopk6B1EIIgeMWX
key:                  http2-4.2.2-9Su0rTsdopk6B1EIIgeMWX
license:              BSD-3-Clause
maintainer:           Kazu Yamamoto <kazu@iij.ad.jp>
author:               Kazu Yamamoto <kazu@iij.ad.jp>
homepage:             https://github.com/kazu-yamamoto/http2
synopsis:             HTTP/2 library
description:
    HTTP/2 library including frames, priority queues, HPACK, client and server.

category:             Network
abi:                  5bdedc2d0e7759119aaa555fb7e52071
exposed:              True
exposed-modules:
    Network.HPACK Network.HPACK.Internal Network.HPACK.Table
    Network.HPACK.Token Network.HTTP2.Client
    Network.HTTP2.Client.Internal Network.HTTP2.Frame
    Network.HTTP2.Internal Network.HTTP2.Server
    Network.HTTP2.Server.Internal

hidden-modules:
    Imports Network.HPACK.Builder Network.HTTP2.Client.Types
    Network.HTTP2.Client.Run Network.HPACK.HeaderBlock
    Network.HPACK.HeaderBlock.Decode Network.HPACK.HeaderBlock.Encode
    Network.HPACK.HeaderBlock.Integer Network.HPACK.Huffman
    Network.HPACK.Huffman.Bit Network.HPACK.Huffman.ByteString
    Network.HPACK.Huffman.Decode Network.HPACK.Huffman.Encode
    Network.HPACK.Huffman.Params Network.HPACK.Huffman.Table
    Network.HPACK.Huffman.Tree Network.HPACK.Table.Dynamic
    Network.HPACK.Table.Entry Network.HPACK.Table.RevIndex
    Network.HPACK.Table.Static Network.HPACK.Types Network.HTTP2.Arch
    Network.HTTP2.Arch.Cache Network.HTTP2.Arch.Config
    Network.HTTP2.Arch.Context Network.HTTP2.Arch.EncodeFrame
    Network.HTTP2.Arch.File Network.HTTP2.Arch.HPACK
    Network.HTTP2.Arch.Manager Network.HTTP2.Arch.Queue
    Network.HTTP2.Arch.Rate Network.HTTP2.Arch.ReadN
    Network.HTTP2.Arch.Receiver Network.HTTP2.Arch.Sender
    Network.HTTP2.Arch.Status Network.HTTP2.Arch.Stream
    Network.HTTP2.Arch.Types Network.HTTP2.Arch.Window
    Network.HTTP2.Frame.Decode Network.HTTP2.Frame.Encode
    Network.HTTP2.Frame.Types Network.HTTP2.Server.Run
    Network.HTTP2.Server.Types Network.HTTP2.Server.Worker

import-dirs:          /usr/lib/ghc-9.4.8/site-local/http2-4.2.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/http2-4.2.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/http2-4.2.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-http2
hs-libraries:         HShttp2-4.2.2-9Su0rTsdopk6B1EIIgeMWX
depends:
    array-0.5.4.0 async-2.2.5-BbDohv985MkKG2Ydm62Fmc base-4.17.2.1
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-761P1jvxXU26pNc4Eb30SJ
    containers-0.6.7 http-types-0.12.4-BqXeLjMsy2zE8Q8bHBFhrt
    network-3.1.4.0-K2TPJT2eLM87X4awxEjMbA
    network-byte-order-0.1.7-D2CHdiOOdOK1rEVBtge3lM
    psqueues-0.2.8.2-Ep2m3OqGW8iLUeuNUHyhks stm-2.5.1.0
    time-manager-0.0.1-2uPBqvBk0wjEsmZCo56E59
    unix-time-0.4.17-4rHXlNMpgj094VGRgrPsGa
    unliftio-0.2.25.1-CgePo7ngrPgLZdb5MfeeLl

haddock-interfaces:   /usr/share/doc/haskell-http2/html/http2.haddock
haddock-html:         /usr/share/doc/haskell-http2/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

