#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 http2
version:              4.2.1
visibility:           public
id:                   http2-4.2.1-FqCjCJybX0aEGbwluN8IYM
key:                  http2-4.2.1-FqCjCJybX0aEGbwluN8IYM
license:              BSD-3-Clause
maintainer:           Kazu Yamamoto <kazu@iij.ad.jp>
author:               Kazu Yamamoto <kazu@iij.ad.jp>
homepage:             https://github.com/kazu-yamamoto/http2
synopsis:             HTTP/2 library
description:
    HTTP/2 library including frames, priority queues, HPACK, client and server.

category:             Network
abi:                  814251979800fa2a6d2a3ad422a2cfc9
exposed:              True
exposed-modules:
    Network.HPACK Network.HPACK.Internal Network.HPACK.Table
    Network.HPACK.Token Network.HTTP2.Client
    Network.HTTP2.Client.Internal Network.HTTP2.Frame
    Network.HTTP2.Internal Network.HTTP2.Server
    Network.HTTP2.Server.Internal

hidden-modules:
    Imports Network.HPACK.Builder Network.HTTP2.Client.Types
    Network.HTTP2.Client.Run Network.HPACK.HeaderBlock
    Network.HPACK.HeaderBlock.Decode Network.HPACK.HeaderBlock.Encode
    Network.HPACK.HeaderBlock.Integer Network.HPACK.Huffman
    Network.HPACK.Huffman.Bit Network.HPACK.Huffman.ByteString
    Network.HPACK.Huffman.Decode Network.HPACK.Huffman.Encode
    Network.HPACK.Huffman.Params Network.HPACK.Huffman.Table
    Network.HPACK.Huffman.Tree Network.HPACK.Table.Dynamic
    Network.HPACK.Table.Entry Network.HPACK.Table.RevIndex
    Network.HPACK.Table.Static Network.HPACK.Types Network.HTTP2.Arch
    Network.HTTP2.Arch.Cache Network.HTTP2.Arch.Config
    Network.HTTP2.Arch.Context Network.HTTP2.Arch.EncodeFrame
    Network.HTTP2.Arch.File Network.HTTP2.Arch.HPACK
    Network.HTTP2.Arch.Manager Network.HTTP2.Arch.Queue
    Network.HTTP2.Arch.Rate Network.HTTP2.Arch.ReadN
    Network.HTTP2.Arch.Receiver Network.HTTP2.Arch.Sender
    Network.HTTP2.Arch.Status Network.HTTP2.Arch.Stream
    Network.HTTP2.Arch.Types Network.HTTP2.Arch.Window
    Network.HTTP2.Frame.Decode Network.HTTP2.Frame.Encode
    Network.HTTP2.Frame.Types Network.HTTP2.Server.Run
    Network.HTTP2.Server.Types Network.HTTP2.Server.Worker

import-dirs:          /usr/lib/ghc-9.4.8/site-local/http2-4.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/http2-4.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/http2-4.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-http2
hs-libraries:         HShttp2-4.2.1-FqCjCJybX0aEGbwluN8IYM
depends:
    array-0.5.4.0 async-2.2.5-6I3Om2iOc9KLV2rb6dASmz base-4.17.2.1
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-9yImpzTIYpBJ0v1fZqtWOj
    containers-0.6.7 http-types-0.12.4-JKUCrzdlATTa7w8tKVNt1
    network-3.1.4.0-DD61ZgteIR5Dyq0QRyt6FX
    network-byte-order-0.1.7-D2CHdiOOdOK1rEVBtge3lM
    psqueues-0.2.8.2-6QE0hu7PanE34cAmyrORrm stm-2.5.1.0
    time-manager-0.0.1-KnYRHTxJrwU22FLAt9ewFR
    unix-time-0.4.17-Ht5yHmfrb3l4e212TanEOg
    unliftio-0.2.25.1-JjviYpOneZe5nxqbIJEFVH

haddock-interfaces:   /usr/share/doc/haskell-http2/html/http2.haddock
haddock-html:         /usr/share/doc/haskell-http2/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

