#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 http-client-restricted
version:              0.1.0
visibility:           public
id:                   http-client-restricted-0.1.0-ISySwTPFh9c4KgL7FIzbaq
key:                  http-client-restricted-0.1.0-ISySwTPFh9c4KgL7FIzbaq
license:              MIT
copyright:            2018 Joey Hess, 2013 Michael Snoyman
maintainer:           Joey Hess <id@joeyh.name>
author:               Joey Hess
synopsis:             restricting the servers that http-client will use
description:
    Addition to the http-client and http-client-tls
    libraries, that restricts the HTTP servers that can be used.

    This is useful when a security policy needs to eg, prevent connections to
    HTTP servers on localhost or a local network, or only allow connections
    to a specific HTTP server.

    It handles restricting redirects as well as the initial HTTP connection,
    and it also guards against DNS poisoning attacks.

category:             Network
abi:                  e9a4fd580f700c71952e0b9a48e1403f
exposed:              True
exposed-modules:      Network.HTTP.Client.Restricted
import-dirs:          /usr/lib/ghc-9.4.8/site-local/http-client-restricted-0.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/http-client-restricted-0.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/http-client-restricted-0.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-http-client-restricted
hs-libraries:         HShttp-client-restricted-0.1.0-ISySwTPFh9c4KgL7FIzbaq
depends:
    base-4.17.2.1 crypton-connection-0.4.3-9njtefs2cjdHTTbYYs7Bzn
    data-default-0.7.1.2-GUUW0V5lisrJnDmYs4YZIH
    http-client-0.7.19-INRexYbbc84G8M9afYhYa4
    http-client-tls-0.3.6.4-4b1LqwZqELbD3PiYpWlMw1
    network-3.1.4.0-480JOeNLV9o5fbqpzcHJCB
    network-bsd-2.8.1.0-FVYMexhdgoihg44V3yAwr
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:
    /usr/share/doc/haskell-http-client-restricted/html/http-client-restricted.haddock

haddock-html:         /usr/share/doc/haskell-http-client-restricted/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

