#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 HTF
version:              0.15.0.1
visibility:           public
id:                   HTF-0.15.0.1-6BMoc63iuKq3LNJyxBimU9
key:                  HTF-0.15.0.1-6BMoc63iuKq3LNJyxBimU9
license:              LGPL-2.1-only
copyright:            (c) 2005-2023 Stefan Wehr
maintainer:           Stefan Wehr
author:               Stefan Wehr
stability:            Beta
homepage:             https://github.com/skogsbaer/HTF/
synopsis:             The Haskell Test Framework
description:
    The Haskell Test Framework (/HTF/ for short) lets you define and organize unit tests,
    QuickCheck properties,
    and black box tests in an
    easy and convenient way. HTF uses a custom preprocessor that collects
    test definitions automatically.

    HTF produces highly readable output
    for failing test cases: it provides exact file name and line number
    information,
    it colors and pretty prints expected and
    actual results, and it displays a diff highlighting the mismatching parts.

    The documentation of the "Test.Framework.Tutorial" module
    provides a tutorial for HTF. The /sample/ directory in
    the HTF repo provides a good starting point for
    a project using HTF.

category:             Testing
abi:                  9eb3037759987d497902312e21f179ac
exposed:              True
exposed-modules:
    Test.Framework Test.Framework.AssertM Test.Framework.BlackBoxTest
    Test.Framework.HUnitWrapper Test.Framework.History
    Test.Framework.JsonOutput Test.Framework.Location
    Test.Framework.Preprocessor Test.Framework.Pretty
    Test.Framework.PrettyHaskell Test.Framework.QuickCheckWrapper
    Test.Framework.TestInterface Test.Framework.TestManager
    Test.Framework.TestTypes Test.Framework.ThreadPool
    Test.Framework.Tutorial Test.Framework.XmlOutput

hidden-modules:
    Paths_HTF Test.Framework.CmdlineOptions Test.Framework.Colors
    Test.Framework.Diff Test.Framework.Process
    Test.Framework.TestReporter Test.Framework.Utils

import-dirs:          /usr/lib/ghc-9.4.8/site-local/HTF-0.15.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/HTF-0.15.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/HTF-0.15.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-htf
hs-libraries:         HSHTF-0.15.0.1-6BMoc63iuKq3LNJyxBimU9
depends:
    Diff-0.4.1-CBiY4eyeiRQG8RHG96uHG4
    HUnit-1.6.2.0-DUvlqmsw2Kp6tCDRl9WtXA
    QuickCheck-2.14.3-2QKb6Hom0yuuAm9FvZ6nN
    aeson-2.1.2.1-2ooOAwlErgbHj6Tyvuh2I5 array-0.5.4.0 base-4.17.2.1
    base64-bytestring-1.2.1.0-LYBwKrQPWkJ322FRFkSmHQ
    bytestring-0.11.5.3 containers-0.6.7
    cpphs-1.20.9.1-KMTErBmnvc26XA8bncSIwV directory-1.3.7.1
    haskell-src-1.0.4.1-CO1nSxP1pSwJ92LzJEbDB4
    lifted-base-0.2.3.12-AELrIAGexwKTexJUnanLP
    monad-control-1.0.3.1-ADBy113jPZx6EyMvvTxyI9 mtl-2.2.2
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9 pretty-1.1.3.6
    process-1.6.18.0 random-1.2.1.3-K04qxPoOyGIAJkhpqYiZaH
    regex-compat-0.95.2.2-XQpODnagAHFJ9GlOSqau8 text-2.0.2 time-1.12.2
    unix-2.7.3 vector-0.13.2.0-BWMo7dqC00725tIPRLs4rJ
    xmlgen-0.6.2.2-2mhZyEx721b5KB61dOe401

haddock-interfaces:   /usr/share/doc/haskell-htf/html/HTF.haddock
haddock-html:         /usr/share/doc/haskell-htf/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

