#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hslua
version:              2.3.0
visibility:           public
id:                   hslua-2.3.0-JIelwCzpvSXKYa7qAgcatT
key:                  hslua-2.3.0-JIelwCzpvSXKYa7qAgcatT
license:              MIT
copyright:
    © 2007–2012 Gracjan Polak;
    © 2012–2016 Ömer Sinan Ağacan;
    © 2017-2023 Albert Krewinkel

maintainer:           tarleb@hslua.org
author:               Albert Krewinkel, Gracjan Polak, Ömer Sinan Ağacan
homepage:             https://hslua.org/
synopsis:             Bindings to Lua, an embeddable scripting language
description:
    HsLua provides wrappers and helpers
    to bridge Haskell and <https://www.lua.org/ Lua>.

    It builds upon the /lua/ package, which allows to bundle
    a Lua interpreter with a Haskell program.

    Example programs are can be found in the @hslua-examples@
    subdir of the project
    <https://github.com/hslua/hslua repository>.

category:             Foreign
abi:                  88b3bfb0b9bdc1f341ee015d78429ab3
exposed:              True
exposed-modules:
    HsLua,
    HsLua.Aeson from hslua-aeson-2.3.1.1-4C2P4g4uWI8DFpsvFkpjTs:HsLua.Aeson,
    HsLua.Class.Exposable from hslua-classes-2.3.0-JQ7zIzNxgRwLi3jFFOkebR:HsLua.Class.Exposable,
    HsLua.Class.Invokable from hslua-classes-2.3.0-JQ7zIzNxgRwLi3jFFOkebR:HsLua.Class.Invokable,
    HsLua.Class.Peekable from hslua-classes-2.3.0-JQ7zIzNxgRwLi3jFFOkebR:HsLua.Class.Peekable,
    HsLua.Class.Pushable from hslua-classes-2.3.0-JQ7zIzNxgRwLi3jFFOkebR:HsLua.Class.Pushable,
    HsLua.Class.Util from hslua-classes-2.3.0-JQ7zIzNxgRwLi3jFFOkebR:HsLua.Class.Util,
    HsLua.Core from hslua-core-2.3.2-CioTfMG9Ml2Lkmjmm7zI9U:HsLua.Core,
    HsLua.Core.Error from hslua-core-2.3.2-CioTfMG9Ml2Lkmjmm7zI9U:HsLua.Core.Error,
    HsLua.Core.Types from hslua-core-2.3.2-CioTfMG9Ml2Lkmjmm7zI9U:HsLua.Core.Types,
    HsLua.Core.Utf8 from hslua-core-2.3.2-CioTfMG9Ml2Lkmjmm7zI9U:HsLua.Core.Utf8,
    HsLua.Marshalling from hslua-marshalling-2.3.1-C0K1WOE0GsN7XQHCGiWLQP:HsLua.Marshalling,
    HsLua.ObjectOrientation from hslua-objectorientation-2.3.1-2lFK9lFfYSBJcya8Ba08xb:HsLua.ObjectOrientation,
    HsLua.Packaging from hslua-packaging-2.3.1-F21C19K6SCt2asti8GbAoA:HsLua.Packaging,
    HsLua.Packaging.Function from hslua-packaging-2.3.1-F21C19K6SCt2asti8GbAoA:HsLua.Packaging.Function,
    HsLua.Packaging.Module from hslua-packaging-2.3.1-F21C19K6SCt2asti8GbAoA:HsLua.Packaging.Module,
    HsLua.Packaging.Rendering from hslua-packaging-2.3.1-F21C19K6SCt2asti8GbAoA:HsLua.Packaging.Rendering,
    HsLua.Typing from hslua-typing-0.1.1-EGbEaUhiMY9LsRyCKaNEQi:HsLua.Typing,
    HsLua.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hslua-2.3.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hslua-2.3.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hslua-2.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hslua
hs-libraries:         HShslua-2.3.0-JIelwCzpvSXKYa7qAgcatT
depends:
    base-4.17.2.1 bytestring-0.11.5.3 containers-0.6.7
    exceptions-0.10.5 hslua-aeson-2.3.1.1-4C2P4g4uWI8DFpsvFkpjTs
    hslua-classes-2.3.0-JQ7zIzNxgRwLi3jFFOkebR
    hslua-core-2.3.2-CioTfMG9Ml2Lkmjmm7zI9U
    hslua-marshalling-2.3.1-C0K1WOE0GsN7XQHCGiWLQP
    hslua-objectorientation-2.3.1-2lFK9lFfYSBJcya8Ba08xb
    hslua-packaging-2.3.1-F21C19K6SCt2asti8GbAoA
    hslua-typing-0.1.1-EGbEaUhiMY9LsRyCKaNEQi mtl-2.2.2 text-2.0.2

haddock-interfaces:   /usr/share/doc/haskell-hslua/html/hslua.haddock
haddock-html:         /usr/share/doc/haskell-hslua/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

