#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hslua
version:              2.3.0
visibility:           public
id:                   hslua-2.3.0-G9GzL9pdVTY6D8GPhmyxwy
key:                  hslua-2.3.0-G9GzL9pdVTY6D8GPhmyxwy
license:              MIT
copyright:
    © 2007–2012 Gracjan Polak;
    © 2012–2016 Ömer Sinan Ağacan;
    © 2017-2023 Albert Krewinkel

maintainer:           tarleb@hslua.org
author:               Albert Krewinkel, Gracjan Polak, Ömer Sinan Ağacan
homepage:             https://hslua.org/
synopsis:             Bindings to Lua, an embeddable scripting language
description:
    HsLua provides wrappers and helpers
    to bridge Haskell and <https://www.lua.org/ Lua>.

    It builds upon the /lua/ package, which allows to bundle
    a Lua interpreter with a Haskell program.

    Example programs are can be found in the @hslua-examples@
    subdir of the project
    <https://github.com/hslua/hslua repository>.

category:             Foreign
abi:                  744d34f4efa220b780c4d7a20aa35bea
exposed:              True
exposed-modules:
    HsLua,
    HsLua.Aeson from hslua-aeson-2.3.1.1-7Ozj8qhQDM6Bg7Fk5Zq1Db:HsLua.Aeson,
    HsLua.Class.Exposable from hslua-classes-2.3.0-1qgRCMNLMMb745yzISoVZI:HsLua.Class.Exposable,
    HsLua.Class.Invokable from hslua-classes-2.3.0-1qgRCMNLMMb745yzISoVZI:HsLua.Class.Invokable,
    HsLua.Class.Peekable from hslua-classes-2.3.0-1qgRCMNLMMb745yzISoVZI:HsLua.Class.Peekable,
    HsLua.Class.Pushable from hslua-classes-2.3.0-1qgRCMNLMMb745yzISoVZI:HsLua.Class.Pushable,
    HsLua.Class.Util from hslua-classes-2.3.0-1qgRCMNLMMb745yzISoVZI:HsLua.Class.Util,
    HsLua.Core from hslua-core-2.3.1-I7hwN7ryucoCWsYNuL3aEZ:HsLua.Core,
    HsLua.Core.Error from hslua-core-2.3.1-I7hwN7ryucoCWsYNuL3aEZ:HsLua.Core.Error,
    HsLua.Core.Types from hslua-core-2.3.1-I7hwN7ryucoCWsYNuL3aEZ:HsLua.Core.Types,
    HsLua.Core.Utf8 from hslua-core-2.3.1-I7hwN7ryucoCWsYNuL3aEZ:HsLua.Core.Utf8,
    HsLua.Marshalling from hslua-marshalling-2.3.1-5lyaLV34zwj8mXDksISscF:HsLua.Marshalling,
    HsLua.ObjectOrientation from hslua-objectorientation-2.3.1-DjJ4BMA4EqE2lkVVzKwH2L:HsLua.ObjectOrientation,
    HsLua.Packaging from hslua-packaging-2.3.1-2cCYDu4shkE9OCdpvXw4tl:HsLua.Packaging,
    HsLua.Packaging.Function from hslua-packaging-2.3.1-2cCYDu4shkE9OCdpvXw4tl:HsLua.Packaging.Function,
    HsLua.Packaging.Module from hslua-packaging-2.3.1-2cCYDu4shkE9OCdpvXw4tl:HsLua.Packaging.Module,
    HsLua.Packaging.Rendering from hslua-packaging-2.3.1-2cCYDu4shkE9OCdpvXw4tl:HsLua.Packaging.Rendering,
    HsLua.Typing from hslua-typing-0.1.1-95FhKlp3hud46rF6uBvJ1q:HsLua.Typing,
    HsLua.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hslua-2.3.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hslua-2.3.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hslua-2.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hslua
hs-libraries:         HShslua-2.3.0-G9GzL9pdVTY6D8GPhmyxwy
depends:
    base-4.17.2.1 bytestring-0.11.5.3 containers-0.6.7
    exceptions-0.10.5 hslua-aeson-2.3.1.1-7Ozj8qhQDM6Bg7Fk5Zq1Db
    hslua-classes-2.3.0-1qgRCMNLMMb745yzISoVZI
    hslua-core-2.3.1-I7hwN7ryucoCWsYNuL3aEZ
    hslua-marshalling-2.3.1-5lyaLV34zwj8mXDksISscF
    hslua-objectorientation-2.3.1-DjJ4BMA4EqE2lkVVzKwH2L
    hslua-packaging-2.3.1-2cCYDu4shkE9OCdpvXw4tl
    hslua-typing-0.1.1-95FhKlp3hud46rF6uBvJ1q mtl-2.2.2 text-2.0.2

haddock-interfaces:   /usr/share/doc/haskell-hslua/html/hslua.haddock
haddock-html:         /usr/share/doc/haskell-hslua/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

