#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hslua
version:              2.3.0
visibility:           public
id:                   hslua-2.3.0-KYbk8LTG4lhGPpzxy3nVeV
key:                  hslua-2.3.0-KYbk8LTG4lhGPpzxy3nVeV
license:              MIT
copyright:
    © 2007–2012 Gracjan Polak;
    © 2012–2016 Ömer Sinan Ağacan;
    © 2017-2023 Albert Krewinkel

maintainer:           tarleb@hslua.org
author:               Albert Krewinkel, Gracjan Polak, Ömer Sinan Ağacan
homepage:             https://hslua.org/
synopsis:             Bindings to Lua, an embeddable scripting language
description:
    HsLua provides wrappers and helpers
    to bridge Haskell and <https://www.lua.org/ Lua>.

    It builds upon the /lua/ package, which allows to bundle
    a Lua interpreter with a Haskell program.

    Example programs are can be found in the @hslua-examples@
    subdir of the project
    <https://github.com/hslua/hslua repository>.

category:             Foreign
abi:                  b1698f87b792cd9d830259ab97cae539
exposed:              True
exposed-modules:
    HsLua,
    HsLua.Aeson from hslua-aeson-2.3.1-KEjqtgc3e5ADM4c0oG84tK:HsLua.Aeson,
    HsLua.Class.Exposable from hslua-classes-2.3.0-DMWWnv0GE71G3Sn5WdD6cF:HsLua.Class.Exposable,
    HsLua.Class.Invokable from hslua-classes-2.3.0-DMWWnv0GE71G3Sn5WdD6cF:HsLua.Class.Invokable,
    HsLua.Class.Peekable from hslua-classes-2.3.0-DMWWnv0GE71G3Sn5WdD6cF:HsLua.Class.Peekable,
    HsLua.Class.Pushable from hslua-classes-2.3.0-DMWWnv0GE71G3Sn5WdD6cF:HsLua.Class.Pushable,
    HsLua.Class.Util from hslua-classes-2.3.0-DMWWnv0GE71G3Sn5WdD6cF:HsLua.Class.Util,
    HsLua.Core from hslua-core-2.3.1-C6gpXh5TvqqLURgePUyTjB:HsLua.Core,
    HsLua.Core.Error from hslua-core-2.3.1-C6gpXh5TvqqLURgePUyTjB:HsLua.Core.Error,
    HsLua.Core.Types from hslua-core-2.3.1-C6gpXh5TvqqLURgePUyTjB:HsLua.Core.Types,
    HsLua.Core.Utf8 from hslua-core-2.3.1-C6gpXh5TvqqLURgePUyTjB:HsLua.Core.Utf8,
    HsLua.Marshalling from hslua-marshalling-2.3.1-JwvRQcwn4p8ImJNLtPPu60:HsLua.Marshalling,
    HsLua.ObjectOrientation from hslua-objectorientation-2.3.0-CQc0dMDuRrq2g3ja4xO94U:HsLua.ObjectOrientation,
    HsLua.Packaging from hslua-packaging-2.3.1-DdQn7iNR8B57R9FLKmr3po:HsLua.Packaging,
    HsLua.Packaging.Function from hslua-packaging-2.3.1-DdQn7iNR8B57R9FLKmr3po:HsLua.Packaging.Function,
    HsLua.Packaging.Module from hslua-packaging-2.3.1-DdQn7iNR8B57R9FLKmr3po:HsLua.Packaging.Module,
    HsLua.Packaging.Rendering from hslua-packaging-2.3.1-DdQn7iNR8B57R9FLKmr3po:HsLua.Packaging.Rendering,
    HsLua.Typing from hslua-typing-0.1.1-2UwdQAmOSNb5XtraWxwIIx:HsLua.Typing,
    HsLua.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hslua-2.3.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hslua-2.3.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hslua-2.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hslua
hs-libraries:         HShslua-2.3.0-KYbk8LTG4lhGPpzxy3nVeV
depends:
    base-4.17.2.1 bytestring-0.11.5.3 containers-0.6.7
    exceptions-0.10.5 hslua-aeson-2.3.1-KEjqtgc3e5ADM4c0oG84tK
    hslua-classes-2.3.0-DMWWnv0GE71G3Sn5WdD6cF
    hslua-core-2.3.1-C6gpXh5TvqqLURgePUyTjB
    hslua-marshalling-2.3.1-JwvRQcwn4p8ImJNLtPPu60
    hslua-objectorientation-2.3.0-CQc0dMDuRrq2g3ja4xO94U
    hslua-packaging-2.3.1-DdQn7iNR8B57R9FLKmr3po
    hslua-typing-0.1.1-2UwdQAmOSNb5XtraWxwIIx mtl-2.2.2 text-2.0.2

haddock-interfaces:   /usr/share/doc/haskell-hslua/html/hslua.haddock
haddock-html:         /usr/share/doc/haskell-hslua/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

