#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hosc
version:              0.20
visibility:           public
id:                   hosc-0.20-I22N4hydCXL37ZzXk3RRro
key:                  hosc-0.20-I22N4hydCXL37ZzXk3RRro
license:              GPL-3.0-only
copyright:            (c) Rohan Drape, Stefan Kersten and others, 2007-2022
maintainer:           rd@rohandrape.net
author:               Rohan Drape, Stefan Kersten
stability:            Experimental
homepage:             http://rohandrape.net/t/hosc
synopsis:             Haskell Open Sound Control
description:
    Haskell library implementing the Open Sound Control protocol

category:             Sound
abi:                  c6f63b5c7f6528aa3f7991031bacfe0b
exposed:              True
exposed-modules:
    Sound.Osc Sound.Osc.Alias Sound.Osc.Coding.Byte
    Sound.Osc.Coding.Cast Sound.Osc.Coding.Convert
    Sound.Osc.Coding.Decode.Base Sound.Osc.Coding.Decode.Binary
    Sound.Osc.Coding.Encode.Base Sound.Osc.Coding.Encode.Builder
    Sound.Osc.Core Sound.Osc.Datum Sound.Osc.Fd Sound.Osc.Packet
    Sound.Osc.Text Sound.Osc.Time Sound.Osc.Time.System
    Sound.Osc.Time.Thread Sound.Osc.Time.Thread.MonadIO
    Sound.Osc.Time.Timeout Sound.Osc.Transport.Fd
    Sound.Osc.Transport.Fd.Tcp Sound.Osc.Transport.Fd.Udp
    Sound.Osc.Transport.Monad Sound.Osc.Wait

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hosc-0.20
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hosc-0.20
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hosc-0.20
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hosc
hs-libraries:         HShosc-0.20-I22N4hydCXL37ZzXk3RRro
depends:
    base-4.17.2.1 binary-0.8.9.1
    blaze-builder-0.4.4-6pj5g3cSiSiJX9apPPZfOV bytestring-0.11.5.3
    data-binary-ieee754-0.4.4-3K4wyZ8KRa1CgKftL8GYsk
    network-3.1.4.0-FZePtqluqyjFxAKIHdZ8Kd parsec-3.1.16.1 time-1.12.2
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-hosc/html/hosc.haddock
haddock-html:         /usr/share/doc/haskell-hosc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

