#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-2E3FUCQ4jgqHM53TUd2jdo
key:                  hOpenPGP-2.10.1-2E3FUCQ4jgqHM53TUd2jdo
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  78dc28db45d5051f30830fbd2a3483ac
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-2E3FUCQ4jgqHM53TUd2jdo
depends:
    aeson-2.1.2.1-4RB85zdNr5p3whZ1np3a31
    asn1-encoding-0.9.6-6qnbPIhPHof3Aoo10UHXmC
    attoparsec-0.14.4-IvgQrznNozFJRhxLBW8JF base-4.17.2.1
    base16-bytestring-1.0.2.0-2HZcxZQrp2G92HohcNwteN
    bifunctors-5.6.2-GEXn7wFr46IB2mzTOaL0O6 binary-0.8.9.1
    binary-conduit-1.3.1-2wTrdFNUbNiJ7UqlzrWTOg bytestring-0.11.5.3
    bz2-1.0.1.1-fBsfbuhISACHKCibCxhHy
    conduit-1.3.6.1-8yY1jDXBMRk90iKvTAknJ8
    conduit-extra-1.3.8-20yj5GJQbJrGq11c4ONfrP containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.3-BZXcruXHL3VF0zOINtJbBE
    errors-2.3.0-9WADp90ucCG6Md13oYVc4N
    hashable-1.4.5.0-EMf4Iv4OllUGRj72K4SCf0
    incremental-parser-0.5.1-jYYIrs8PAnFzFSRq1TTSh
    ixset-typed-0.5.1.0-9xSsQsn6evXF1mJoMHwBzr
    lens-5.3.1-ph5gK6GMHDK3KRhjZ6UP9
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-yi3MP3fDM2AtnMkY6gtjY
    openpgp-asciiarmor-0.1.2-HIO4W729zGjAzzWfIU54vC
    prettyprinter-1.7.1-Akkp0WpHSIjZLnKQ6G5af
    resourcet-1.2.6-2WPOMAIVFIM62rtu43cRpf
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-L410VxfvorQ5RMb8wocThG
    zlib-0.7.0.0-CeIfwSJ4sxN7HYUOQk7SUo

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

