#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-KhtK2zlilJC2ElHDsdr3Q8
key:                  hOpenPGP-2.10.1-KhtK2zlilJC2ElHDsdr3Q8
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  5c404f0aa1aef30e1e39bc986ce6e06c
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-KhtK2zlilJC2ElHDsdr3Q8
depends:
    aeson-2.1.2.1-30WJrKK1Pbc1pP0H7Lz8HG
    asn1-encoding-0.9.6-LAQF2mdo90XHiOLrFlJgSD
    attoparsec-0.14.4-H7aeDSX4mnyDRaYndD48j5 base-4.17.2.1
    base16-bytestring-1.0.2.0-DUqHedAHAQbJjSb7t2C2Fa
    bifunctors-5.6.2-EgMrpkwnq8B7GhdwyuCMdy binary-0.8.9.1
    binary-conduit-1.3.1-8kU3LdrUYrtWMRqWwwXs7 bytestring-0.11.5.3
    bz2-1.0.1.1-9Oi0yuK4Rcw581TeNCm6kC
    conduit-1.3.6.1-L9TggbIlNiTCDF5rGZVa9g
    conduit-extra-1.3.8-19lmWL4nfT7KBh5mbFf6Y1 containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.3-1ao4duKJDxNE83TgrdTz39
    errors-2.3.0-DTMwrjO2JUT9nX41rvROdH
    hashable-1.4.5.0-JHGJZlFhSc53NK2NYV614f
    incremental-parser-0.5.1-2IsHak5B8NgLL1bGtFq0sy
    ixset-typed-0.5.1.0-CanMb0E6syXClKoaGu83jm
    lens-5.3.1-JQiC8s3SxPvAYItR1bILVE
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-4dyZiFqUsAXDJ8mS3jtc8B
    openpgp-asciiarmor-0.1.2-6psaqNNLTWC7WmzayIXrj9
    prettyprinter-1.7.1-GISel4GwMefHj3FidpnW09
    resourcet-1.2.6-FSCUiwlyZ0b8fgSbQ2cm0c
    split-0.2.5-BTOw45Vh0HiC6vu4BN5MeO text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-JDDg5JU7nYP5ffg7vR2UZh
    zlib-0.7.0.0-HXtTAV6BEvXDp6A0D3XVVx

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

