#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-KF2CL8ski698s2qIlbmKSJ
key:                  hOpenPGP-2.10.1-KF2CL8ski698s2qIlbmKSJ
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  6d436fbca791c149a65f451c4f13f4bf
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-KF2CL8ski698s2qIlbmKSJ
depends:
    aeson-2.1.2.1-F8ZePgr6g4xL6kF4wsQx0x
    asn1-encoding-0.9.6-3zZqpTCjUAI3T5rBwwTn3A
    attoparsec-0.14.4-D7CECqktDgS2fYWStxbJq3 base-4.17.2.1
    base16-bytestring-1.0.2.0-6gnnhNAVOchGQBiiZZP74i
    bifunctors-5.6.2-8pUJDNGiMWK2bagGoBlHc6 binary-0.8.9.1
    binary-conduit-1.3.1-GV8gusq21FAZrCIDZZBlj bytestring-0.11.5.3
    bz2-1.0.1.1-1xPLVeFTm5DBcGnHIkCLSO
    conduit-1.3.6.1-Iv674JaqEE17PR7slCoUfp
    conduit-extra-1.3.8-9BT5gTgmegiEww1RLwnr5K containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.3-4UnAyWN8beXD5nwa7txFxR
    errors-2.3.0-KY9EXFoexY0HL93kqBn3gr
    hashable-1.4.5.0-FUZ3820cmTgAr6H2g2EQN7
    incremental-parser-0.5.1-IpmjabG9ZUaLn6zEEN8Vwa
    ixset-typed-0.5.1.0-COyMAcXU7uvHbLgKfKWdDU
    lens-5.3.1-FP95Rv35No71PYJue58Hxp
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-8swvJWOy75N7pbfI8WzbN
    openpgp-asciiarmor-0.1.2-Dh8EtEf1gfTLfe0GzUrd8l
    prettyprinter-1.7.1-AIJZZXuo91NCViNpmKNzcQ
    resourcet-1.2.6-1uUyorfyzWb8h78koH6NVM
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-I3GOf8berWn8tol6ImoSEe
    zlib-0.7.0.0-LNxfZD2yBOpG9CUE6LYKNw

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

