#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-BUG0LuVj0m4SxNMYmLMMu
key:                  hOpenPGP-2.10.1-BUG0LuVj0m4SxNMYmLMMu
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  133aab7086f7f4706c64135161d6375c
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-BUG0LuVj0m4SxNMYmLMMu
depends:
    aeson-2.1.2.1-LvJWrHbVhNW5j5NGQeCpIT
    asn1-encoding-0.9.6-4264oq0sIsv6VCR8zfUiAI
    attoparsec-0.14.4-IxPlyKeM7RE2Q1eOkxwOEV base-4.17.2.1
    base16-bytestring-1.0.2.0-Eyzq7m0xe67GiRftjHundc
    bifunctors-5.6.2-BSCVHmqs5Xn8iLfutEqpNu binary-0.8.9.1
    binary-conduit-1.3.1-4G87JeA3Z4qITlvo7iPCfb bytestring-0.11.5.3
    bz2-1.0.1.1-IjVoktmr2w4KeXUj2n6aw0
    conduit-1.3.6.1-7gDrgQT36z4IN6MqKXM4jU
    conduit-extra-1.3.8-LH0nSmNEDBz6QpPwrMyaiE containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.3-7bIVfz7v17tJuJ7xRVIZw4
    errors-2.3.0-JvmK3jkhOWJ10mfhs01pYS
    hashable-1.4.5.0-tUQ3ISdCwwAzRS3LRBhXn
    incremental-parser-0.5.1-7YRhM6Wt3T86sgAMMAcepL
    ixset-typed-0.5.1.0-ION46MI7jxOKWtTNrTcAep
    lens-5.3.1-1aYkBqtQBz47fMfVuyOc0c
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-U3v26HNy1l6rJ9sPiQ7eG
    openpgp-asciiarmor-0.1.2-8sTdDigEdcoLIsXizepOYb
    prettyprinter-1.7.1-2R6NgwfUgVc9iM5YqEeKHX
    resourcet-1.2.6-2BcDKwHjSabK2j2MMy69bs
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-Kt9XOM1GYdv4KClqugAe9a
    zlib-0.7.0.0-9Zx3bu1purBDV0Kt6BJOMV

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

