#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-Hh1K2IAgx3tKTF2HYVC1FR
key:                  hOpenPGP-2.10.1-Hh1K2IAgx3tKTF2HYVC1FR
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  a0987c31757537134c95d1b6ce8e43b6
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-Hh1K2IAgx3tKTF2HYVC1FR
depends:
    aeson-2.1.2.1-6ANjbGmrSDg8K6hz3VmYXP
    asn1-encoding-0.9.6-9ArByk5NutrFkRwM00sH1K
    attoparsec-0.14.4-G1kY79wp4BCwb0EQHIFQA base-4.17.2.1
    base16-bytestring-1.0.2.0-HAJb6KkTWjgCS5rMtXMipF
    bifunctors-5.6.2-ASXTwgeHUT09TqDX9FqnHc binary-0.8.9.1
    binary-conduit-1.3.1-7zVAAIZ8PdE1TRQAbzzbuI bytestring-0.11.5.3
    bz2-1.0.1.1-IWEt9uOtlPqC28Rvyq78aE
    conduit-1.3.6.1-4l30t2Ip4GHEHw4ixGv2i5
    conduit-extra-1.3.8-GK7eB8KrTj0DDdk6UIy2sa containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.3-4ze0wyRfIfo3Yl9n4jOf0m
    errors-2.3.0-F3myTQOIJH0ChUTUB0SwFe
    hashable-1.4.4.0-L4Cy5OzOiFo7EDda82f1f2
    incremental-parser-0.5.1-ATVFT8Ndom21m6UVZPvnPC
    ixset-typed-0.5.1.0-6JtbmlI06yI7gLY1UYPSfZ
    lens-5.3.1-7KUGOKnL0sFAtVCcawlRvA
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-DCTjueINivX2RvibFUmCb5
    openpgp-asciiarmor-0.1.2-LFsxQ4dFczNCAnXGTfgeO5
    prettyprinter-1.7.1-H1CnA9YdkYYkwP4aBwQ7e
    resourcet-1.2.6-51POVGcTQTcIqRtsN2Sw66
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-6WajAJaPEOH3f3auRxdjt7
    zlib-0.7.0.0-JzSh6x0Wz1B4h2omw65Rcm

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

