#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-7IwIMmkdkXh63ABQMA1hLT
key:                  hOpenPGP-2.10.1-7IwIMmkdkXh63ABQMA1hLT
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  e6da8953cdd924fb9f6884b99643398f
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-7IwIMmkdkXh63ABQMA1hLT
depends:
    aeson-2.1.2.1-6q2KNYwRaL29rPm6MMaiUC
    asn1-encoding-0.9.6-AfQPJeXAX4cBrBodWVHFmv
    attoparsec-0.14.4-AfQEBsI4KfUBbsB9NxUVAd base-4.17.2.1
    base16-bytestring-1.0.2.0-3kwon8iNzO25udiTa31L4P
    bifunctors-5.6.2-FSG0dBjaJY55cmJ113Zetv binary-0.8.9.1
    binary-conduit-1.3.1-Ldjz7pcEzFwA4LkfIabGvm bytestring-0.11.5.3
    bz2-1.0.1.1-KqRp5hJYudiJUfCXVyU6yX
    conduit-1.3.6.1-5V2PSjSHeYS5sF2XpXfdrm
    conduit-extra-1.3.8-AFR5r0hqxtKmjLH3pCwC0 containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.2-3kTRh48C9vj8NaVkp2XHlj
    errors-2.3.0-CAMcPUsPwhbEMu2Inzurc8
    hashable-1.4.4.0-AmJtI56ndXc1GvGfBNNgwb
    incremental-parser-0.5.1-Kmxosv9EC2bEaHRs0MBj6w
    ixset-typed-0.5.1.0-FEDCOLcCo7KDlD4EyI3kpH
    lens-5.3.1-LF4jCoE0w776e2gq32lhyl
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-4guMK9PpDjI4XiQikAf4nE
    openpgp-asciiarmor-0.1.2-LGLxdhfvgs23w9k8lEwlS
    prettyprinter-1.7.1-5xgqmGXqgSr2RPa1NTsZyQ
    resourcet-1.2.6-KFdVdoMdUy2HAqiIe2FuFP
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-3NcLl7S6t7kAuh7l4Ieeoo
    zlib-0.7.0.0-6t7E8pSANES5j7b97RkZZY

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

