#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-3Z111AeUCiN2kxs1euDkpB
key:                  hOpenPGP-2.10.1-3Z111AeUCiN2kxs1euDkpB
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  47e18e55a43cd703984c5c93609b6d66
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-3Z111AeUCiN2kxs1euDkpB
depends:
    aeson-2.1.2.1-8gRdOgbBkF57DAEniCzHis
    asn1-encoding-0.9.6-9scscymHuqv17a4ksX3rQP
    attoparsec-0.14.4-BuoYNqKkZ0cK5gzfHXNsJW base-4.17.2.1
    base16-bytestring-1.0.2.0-C3cPjjLt0AO1rbHXbT6P0Z
    bifunctors-5.6.2-B9wj2UEf2xa949Ragriipa binary-0.8.9.1
    binary-conduit-1.3.1-72PryQrnoqK3IwVASC1ptf bytestring-0.11.5.3
    bz2-1.0.1.1-3QxbtdzVzQS8xSSRK1fGnl
    conduit-1.3.6.1-EEoD2QArhRxFbtxrlaKgkd
    conduit-extra-1.3.8-4vGcjD1RnCr9zclEb4aEgy containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.2-JusZyiOHHprBKng1nU1y0l
    errors-2.3.0-KgwQvvJ2quPCi0TXjLUFu
    hashable-1.4.4.0-C1fFIG7AZLC7j0jzLm97Uw
    incremental-parser-0.5.1-54ZsNzBNJwQ6DKvdbl4ALP
    ixset-typed-0.5.1.0-BllSUaEhHC483Wh3KwBSS
    lens-5.3-6U8rnlrA3UzGhSFoVj5hOc
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-6QHuxl9r30A5vsu5UpWUoB
    openpgp-asciiarmor-0.1.2-5nPihklUeaV7b5oKP2iUNO
    prettyprinter-1.7.1-H0iQpJbBZ6k9IFy5REj5dh
    resourcet-1.2.6-9JXf0ifNhclLJYQG5fNMEA
    split-0.2.5-B9q8eJqGWtOKQzzX1ITTGf text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-obNV32ZSreHxgWRz6JrKP
    zlib-0.7.0.0-ClmxrPWTDgrGZgFhkWmoWv

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

