#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-LcR3HBfQAmZIHwHf27lTdJ
key:                  hOpenPGP-2.10.1-LcR3HBfQAmZIHwHf27lTdJ
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  419123da8e4bb0643ffdbf91b1a3d852
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-LcR3HBfQAmZIHwHf27lTdJ
depends:
    aeson-2.1.2.1-F9MXb1A8ug6GkYytoGh4jA
    asn1-encoding-0.9.6-L6itVSpMOJPDoo4SstJ97o
    attoparsec-0.14.4-Ie40PJLLZWYz4b9BsvrTL base-4.17.2.1
    base16-bytestring-1.0.2.0-5vlLRlPqKexCB3C79nTCDd
    bifunctors-5.6.2-ArandW6RKKhK3jk80Btw1E binary-0.8.9.1
    binary-conduit-1.3.1-Csa1ErVCOTfI8Z7Z4nMAKl bytestring-0.11.5.3
    bz2-1.0.1.1-KHtPS4g5SfdDq8WBVBiXw8
    conduit-1.3.6.1-CCtPFpNy3fRKBOD4qyidjk
    conduit-extra-1.3.8-ASYFEhXdR7WKDdpUeOtDC7 containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.2-7o8Jrkh7igGF3aYIPFY8Rt
    errors-2.3.0-LsZdfka1rK2Ao929KKZAY0
    hashable-1.4.4.0-FG1b1gw3lrmKPDYe5KupbE
    incremental-parser-0.5.1-1WV8wyrvOXpK8R4G18yLZ5
    ixset-typed-0.5.1.0-CJypXySGHDAC77GP7beVDm
    lens-5.3-HdczP0no6IA6OsB2lfUnLL
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-L8nDuI5zE9yEZ3pwnnu7AU
    openpgp-asciiarmor-0.1.2-FVBe5eK7cDY5vKHvYPN3z5
    prettyprinter-1.7.1-3W0ElPC5NNG6rVoiMzjO1q
    resourcet-1.2.6-5AgdTIbDLcu478YFeCE7tB
    split-0.2.5-JeJxVdKJRKMda8iubaxqh text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-Kb1zmdIZFsX5Z4trT8w0xB
    zlib-0.7.0.0-2L6cf4JxwJ39BT8yAGAP2z

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

