#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-p0XVhPuzY65ZOp9zYR98k
key:                  hOpenPGP-2.10.1-p0XVhPuzY65ZOp9zYR98k
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  776beb22fcd5facac4319e6ab72262e9
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-p0XVhPuzY65ZOp9zYR98k
depends:
    aeson-2.1.2.1-4cRYi3WcVwTKRqMhXUztfB
    asn1-encoding-0.9.6-AWiuOFUuwQhJxM9q8kIfaX
    attoparsec-0.14.4-CvEJsUQt6CCDts1bkyqJXU base-4.17.2.1
    base16-bytestring-1.0.2.0-3fBZP0w16aFKJmcNXn7qs9
    bifunctors-5.6.2-FU57F3dDqQ4DB0yKNPKFxr binary-0.8.9.1
    binary-conduit-1.3.1-2L1tV2MUx6nKPY24Sg8jGE bytestring-0.11.5.3
    bz2-1.0.1.1-8FyaxcP7FLa1Zmxco3HPtk
    conduit-1.3.6.1-KZNeLPeXvjD5EEhRbg4Ht8
    conduit-extra-1.3.8-Gwq2qlVhV3jEWryL83GuOP containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.2-LneO5TY4WJpHWl904fsHIO
    errors-2.3.0-6mVUXKGLN7c7ltF8HoJy3C
    hashable-1.4.4.0-4IkOt4KzeSSA3Xc4u5PLaT
    incremental-parser-0.5.1-6jn5FPkLcmV5CbjMBBBibC
    ixset-typed-0.5.1.0-AVk5bRYnbEo2wN1FetgRxw
    lens-5.3-2T63PvFtwZXqnWv0im5sF memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-HPE7I962wSKDZCCiANqdpI
    openpgp-asciiarmor-0.1.2-JW1gzY32wD36HD3RRFhYXb
    prettyprinter-1.7.1-G4E3PI2BTIHFT7NfmJKOqD
    resourcet-1.2.6-4s6buasN4G4AuwCuvXVHSL
    split-0.2.5-JeJxVdKJRKMda8iubaxqh text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-A2tjqfQXDXnFd3Ae9FP0C3
    zlib-0.7.0.0-9VKkwvkCFKSF8i1zwIFecl

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

