#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-DcsppNf4YDn7lteDNodVGu
key:                  hOpenPGP-2.10.1-DcsppNf4YDn7lteDNodVGu
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  7fe4cd35019b5ab83a42df878d3ef311
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-DcsppNf4YDn7lteDNodVGu
depends:
    aeson-2.1.2.1-3LOl3stht3x9JybSpHkoQT
    asn1-encoding-0.9.6-7usdaJgjrV05vbwBXVIZkX
    attoparsec-0.14.4-IjP3u1baQ7d7AdktrTB8o9 base-4.17.2.1
    base16-bytestring-1.0.2.0-JN2q3BvN0xnLDPu9Hux7SV
    bifunctors-5.6.2-1dYsna0Rjjh1L5D7in8wCK binary-0.8.9.1
    binary-conduit-1.3.1-AwTNEc63cfdLvnyrzwV2gY bytestring-0.11.5.3
    bz2-1.0.1.1-ARvu5Id9HNKHTBDqb808E6
    conduit-1.3.6.1-EW1DZSLxYltGXIcrYWVDWp
    conduit-extra-1.3.8-DOUKw0fE0l5Jtslu93zZRD containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.4-IAATRfKOsBm7gMPlaLRwS1
    errors-2.3.0-Lnujydz7p30J6DigSW9ZIO
    hashable-1.4.7.0-bh6X3bZPF56LQTYQ27khw
    incremental-parser-0.5.1-8QcPDmJYX9MCzqLGjCcB5U
    ixset-typed-0.5.1.0-6VpU9IfGjaTHRu3CjNsN6B
    lens-5.3.3-26VlyqkFVMA2DXZQVmsUyD
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-KmmPt5MfJi07BPtstNPoD0
    openpgp-asciiarmor-0.1.2-5o8Aw3g94mwAmj90Tx0MG9
    prettyprinter-1.7.1-CmgwT0JRRi5IrbNzmhPK5a
    resourcet-1.2.6-BjVvYpvovCOJ16EMcKLjlI
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20.1-98Hg6PuNW0XDqLHXL1727Z
    zlib-0.7.0.0-GmXsdmOezz3ojQH5A3eIK

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

