#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-lib
version:              1.42.1
visibility:           public
id:                   hledger-lib-1.42.1-E4d6tfZGLXLJ6Fc2tqvo6I
key:                  hledger-lib-1.42.1-E4d6tfZGLXLJ6Fc2tqvo6I
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             A library providing the core functionality of hledger
description:
    This library contains hledger'\''s core functionality.
    It is used by most hledger* packages so that they support the same
    command line options, file formats, reports, etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting.

    See also:

    - https://hledger.org - hledger'\''s home page

    - https://hledger.org/dev.html - starting point for hledger'\''s developer docs

    - https://hackage.haskell.org/package/hledger-lib/docs/Hledger.html - starting point for hledger'\''s haddock docs

category:             Finance
abi:                  ae82dd3e439a0b6c60246ea28a0b8828
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Balancing Hledger.Data.Currency
    Hledger.Data.Dates Hledger.Data.Errors Hledger.Data.Journal
    Hledger.Data.JournalChecks Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.RulesReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Hledger.Write.Beancount Hledger.Write.Csv Hledger.Write.Html
    Hledger.Write.Html.Attribute Hledger.Write.Html.Blaze
    Hledger.Write.Html.HtmlCommon Hledger.Write.Html.Lucid
    Hledger.Write.Ods Hledger.Write.Spreadsheet Text.Tabular.AsciiWide
    Text.WideString

hidden-modules:       Paths_hledger_lib
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.42.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.42.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.42.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.42.1-E4d6tfZGLXLJ6Fc2tqvo6I
depends:
    Decimal-0.5.2-LMKo4ChlKtKGTJQoPteyo1
    Glob-0.10.2-Gs2itX1ZAT99ilPqAxoAaD
    aeson-2.1.2.1-7VTFzNaeQhH4xougawMBap
    aeson-pretty-0.8.10-rURyXjN4BvGGSaNmtsiAe
    ansi-terminal-1.0.2-JNQYc01xThWEgUAi55dqd4 array-0.5.4.0
    base-4.17.2.1 base-compat-0.14.0-D6ySGt5shRqHRPQXrHl9Oo
    blaze-html-0.9.2.0-IDybBwOqjaeDYYIVGdUmMh
    blaze-markup-0.8.3.0-BiOu39W6ZqkIuEgphwproy bytestring-0.11.5.3
    call-stack-0.4.0-AAQ0PbHtRxA9hkeprsdCAo
    cassava-0.5.4.1-LwcM7gX8eiWC51505zDOUq
    cassava-megaparsec-2.1.1-H6RJPNi3wIjLJptxp38U4y
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    colour-2.3.6-2wv2ltb9NHWFgnG7RawbOn containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd deepseq-1.4.8.0
    directory-1.3.7.1 doclayout-0.4.0.1-6VVuUfkRSSFL4dBKG7D4kM
    encoding-0.10.2-8Iwvsr3jdTTJuHZovYmHGI
    extra-1.7.16-1cKp5Cy9JHKKmY0j3a7DvM
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    hashtables-1.4.2-KkoXKI7zKbkCmeiJfzhtBM
    lucid-2.11.20250303-85dma79ei7Z9DLY1D1vfol
    megaparsec-9.7.0-EiOytuystFBC1v5RoiaLHB
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669 mtl-2.2.2
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    pretty-simple-4.1.3.0-IuchbPKvGM61rhkpenzowc process-1.6.18.0
    regex-tdfa-1.3.2.4-Fuwr2ihnaho7XtY5yWf5G3
    safe-0.3.21-EvJ6Ca7ZgFx49PYHKYQDLu
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5.2-8MWT7CdCODFHs3Dq0tvOIE
    tasty-hunit-0.10.2-70LpSLL8HPZDdfp28bsqWz template-haskell-2.19.0.0
    terminal-size-0.3.4-G9QKE0nIH70HWdqrMvHn0A text-2.0.2 time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    uglymemo-0.1.0.1-8AX9zjlFnnmIrnTboBgOzO
    unordered-containers-0.2.20-Iia3zhz8DVL3Efh3E6ja96
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

