#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-lib
version:              1.40
visibility:           public
id:                   hledger-lib-1.40-CgAzynLJSkI5XofyR22fKg
key:                  hledger-lib-1.40-CgAzynLJSkI5XofyR22fKg
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             A library providing the core functionality of hledger
description:
    This library contains hledger'\''s core functionality.
    It is used by most hledger* packages so that they support the same
    command line options, file formats, reports, etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting.

    See also:

    - https://hledger.org - hledger'\''s home page

    - https://hledger.org/dev.html - starting point for hledger'\''s developer docs

    - https://hackage.haskell.org/package/hledger-lib/docs/Hledger.html - starting point for hledger'\''s haddock docs

category:             Finance
abi:                  4b6e634abec971e6ed0cb915d387a92b
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Balancing Hledger.Data.Dates
    Hledger.Data.Errors Hledger.Data.Journal Hledger.Data.JournalChecks
    Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.RulesReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Hledger.Write.Csv Hledger.Write.Html Hledger.Write.Ods
    Hledger.Write.Spreadsheet Text.Tabular.AsciiWide

hidden-modules:       Text.WideString Paths_hledger_lib
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.40-CgAzynLJSkI5XofyR22fKg
depends:
    Decimal-0.5.2-2CgyFe8EZ1Z9PnfiQRcyVh
    Glob-0.10.2-764h5cYcB8vCtmvdhQwP4D
    aeson-2.1.2.1-F8ZePgr6g4xL6kF4wsQx0x
    aeson-pretty-0.8.10-7LLoAxhJYrxHVdlJthoYBc
    ansi-terminal-1.0.2-vFVvoY6zrCCEYOqozRT68 array-0.5.4.0
    base-4.17.2.1 base-compat-0.13.1-8jgXJjtFto7AX0ry1QXDcA
    blaze-markup-0.8.3.0-3B7X73TXz7h4xBgQnwPnu3 bytestring-0.11.5.3
    call-stack-0.4.0-AAQ0PbHtRxA9hkeprsdCAo
    cassava-0.5.4.1-Fa5MhephXv32XsZlJqWK0h
    cassava-megaparsec-2.1.1-E7QCu2NKJ64ImLqWm5vsKU
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    colour-2.3.6-LEHIraXdsTIL7HQceHTRk6 containers-0.6.7
    data-default-0.7.1.2-2qohbnSvS9oK93FFGOJ5gM deepseq-1.4.8.0
    directory-1.3.7.1 doclayout-0.4.0.1-4fhF0iPNdtv5u9BnMIFbnx
    extra-1.7.16-DH9VMRj2B4M59QQF4Jl9K7
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    hashtables-1.4.1-FW0vV75K1vELWtIXdjv4wT
    lucid-2.11.20250303-6fkFqUgwvJw1VbSHgGbLjZ
    megaparsec-9.7.0-7jzSygYb9UCHSxVBa30IvK
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669 mtl-2.2.2
    pager-0.1.1.0-B0AAr57RfF55sRRPPnbeg
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    pretty-simple-4.1.3.0-5lf1cQ3H4drE0DLfrcpuJ3
    regex-tdfa-1.3.2.4-KR4bJeAvhxe7xzLSY8hs1u
    safe-0.3.21-6M2s73s6VIBE0aNh1wWxu0
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5-9hWWTLU4TD7KXa5mGiIM0S
    tasty-hunit-0.10.2-3oBrkpOPS7zFYCRJh0i4GW template-haskell-2.19.0.0
    terminal-size-0.3.4-G9QKE0nIH70HWdqrMvHn0A text-2.0.2
    text-ansi-0.3.0.1-JZ42qBZ5BUQ2yVkAfbeRZK time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    uglymemo-0.1.0.1-8AX9zjlFnnmIrnTboBgOzO
    unordered-containers-0.2.20-I3GOf8berWn8tol6ImoSEe
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

