#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-lib
version:              1.34
visibility:           public
id:                   hledger-lib-1.34-IOrP68VNjlyJ7tSteH29lQ
key:                  hledger-lib-1.34-IOrP68VNjlyJ7tSteH29lQ
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             A library providing the core functionality of hledger
description:
    This library contains hledger'\''s core functionality.
    It is used by most hledger* packages so that they support the same
    command line options, file formats, reports, etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting.

    See also:

    - https://hledger.org - hledger'\''s home page

    - https://hledger.org/dev.html - starting point for hledger'\''s developer docs

    - https://hackage.haskell.org/package/hledger-lib/docs/Hledger.html - starting point for hledger'\''s haddock docs

category:             Finance
abi:                  9ebd7ddce90f95c84487d2ef5102224c
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Balancing Hledger.Data.Dates
    Hledger.Data.Errors Hledger.Data.Journal Hledger.Data.JournalChecks
    Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader Hledger.Read.CsvUtils
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.RulesReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Text.Tabular.AsciiWide

hidden-modules:
    Text.Megaparsec.Custom Text.WideString Paths_hledger_lib

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.34
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.34
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.34
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.34-IOrP68VNjlyJ7tSteH29lQ
depends:
    Decimal-0.5.2-FxkNPhsZzXo2YJiBcl3tH0
    Glob-0.10.2-5xclHbvDGhqEu2LdSOR2mc
    aeson-2.1.2.1-4cRYi3WcVwTKRqMhXUztfB
    aeson-pretty-0.8.10-HNTMWj24mP2BSAsGYS1aNs
    ansi-terminal-1.0.2-4F37L3ko1KQ1hALBi4f5f0 array-0.5.4.0
    base-4.17.2.1 base-compat-0.12.3-H9qTMlLoDHsHlMi1O3x7Rp
    blaze-markup-0.8.3.0-LoFuvEUpMWsE3h8IrKFaX0 bytestring-0.11.5.3
    call-stack-0.4.0-AAQ0PbHtRxA9hkeprsdCAo
    cassava-0.5.4.0-FRBnSSGWZ1nK8u7fyAk3Ai
    cassava-megaparsec-2.1.1-5A1yIkjgy076YMV3M3DRzA
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    colour-2.3.6-6njshzwl3Y96OgDPg7Krup containers-0.6.7
    data-default-0.7.1.2-86VyjkfSCk63mGj7Z05i2D deepseq-1.4.8.0
    directory-1.3.7.1 doclayout-0.4.0.1-DYIG4TLCHPj7OttFZFQOk4
    extra-1.7.16-A351zU6dpS39u0BZ3kHe7I
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    hashtables-1.4.0-BFP1tPsGqZWCYNfSgEfjIp
    megaparsec-9.6.1-GErkrd4BuZw1o2z4Ja9YFU
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669 mtl-2.2.2
    pager-0.1.1.0-2rV1FpjWLG4cIoyVdIzVy
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    pretty-simple-4.1.3.0-D2myQsZ10nhLeXXigtJ5xd
    regex-tdfa-1.3.2.4-D7EB2Wsznhz2vCgXaQdDLa
    safe-0.3.21-I6HqCqj5Wiu30StmjnRW6G
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.4.3-EjyvceRmrrr5McFRQ3mzqf
    tasty-hunit-0.10.1-9mrn7kt3OP83Ugzin90Ojt template-haskell-2.19.0.0
    terminal-size-0.3.4-G9QKE0nIH70HWdqrMvHn0A text-2.0.2
    text-ansi-0.3.0.1-BDSo3fzqKxJ3BhrFT7VWTx time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    uglymemo-0.1.0.1-8AX9zjlFnnmIrnTboBgOzO
    unordered-containers-0.2.20-A2tjqfQXDXnFd3Ae9FP0C3
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

